/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.utils.ILogger;
import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleAvds
extends AndroidFacetScopedService {
    private static final Key<ModuleAvds> KEY = Key.create((String)ModuleAvds.class.getName());
    private AvdManager myAvdManager;

    @NotNull
    public static ModuleAvds getInstance(@NotNull AndroidFacet facet) {
        ModuleAvds avds = (ModuleAvds)facet.getUserData(KEY);
        if (avds == null) {
            avds = new ModuleAvds(facet);
            facet.putUserData(KEY, avds);
        }
        return avds;
    }

    public static void disposeInstance(@NotNull AndroidFacet facet) {
        ModuleAvds avds = (ModuleAvds)facet.getUserData(KEY);
        if (avds != null) {
            Disposer.dispose((Disposable)avds);
        }
    }

    private ModuleAvds(@NotNull AndroidFacet facet) {
        super(facet);
    }

    @NotNull
    public AvdInfo[] getAllAvds() {
        AvdManager manager = this.getAvdManagerSilently();
        if (manager != null && this.reloadAvds(manager)) {
            return manager.getAllAvds();
        }
        return new AvdInfo[0];
    }

    private boolean reloadAvds(@NotNull AvdManager manager) {
        Project project = this.getModule().getProject();
        try {
            MessageBuildingSdkLog log = new MessageBuildingSdkLog();
            manager.reloadAvds((ILogger)log);
            if (!log.getErrorMessage().isEmpty()) {
                String message = AndroidBundle.message("cant.load.avds.error.prefix", new Object[0]) + ' ' + log.getErrorMessage();
                Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
            }
            return true;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("cant.load.avds.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return false;
        }
    }

    @NotNull
    public AvdInfo[] getValidCompatibleAvds() {
        AvdManager manager = this.getAvdManagerSilently();
        ArrayList<AvdInfo> result = new ArrayList<AvdInfo>();
        if (manager != null && this.reloadAvds(manager)) {
            this.addCompatibleAvds(result, manager.getValidAvds());
        }
        return result.toArray(new AvdInfo[result.size()]);
    }

    @NotNull
    private AvdInfo[] addCompatibleAvds(@NotNull List<AvdInfo> to, @NotNull AvdInfo[] from) {
        AndroidVersion minSdk = AndroidModuleInfo.getInstance(this.getFacet()).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            Logger.getInstance(this.getClass()).error("Android Platform not set for module: " + this.getModule().getName());
            return new AvdInfo[0];
        }
        for (AvdInfo avd : from) {
            ISystemImage systemImage = avd.getSystemImage();
            if (systemImage != null && LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), systemImage).isCompatible() == ThreeState.NO) continue;
            to.add(avd);
        }
        return to.toArray(new AvdInfo[to.size()]);
    }

    @Nullable
    public AvdManager getAvdManagerSilently() {
        try {
            return this.getAvdManager(new AvdManagerLog());
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            return null;
        }
    }

    @Nullable
    public AvdManager getAvdManager(@NotNull ILogger log) throws AndroidLocation.AndroidLocationException {
        if (this.myAvdManager == null) {
            AndroidSdkData.getSdkData(this.getFacet());
            this.myAvdManager = AvdManager.getInstance((AndroidSdkHandler)AndroidSdkData.getSdkHolder(this.getFacet()), (ILogger)log);
        }
        return this.myAvdManager;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        facet.putUserData(KEY, null);
    }
}

