/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinChooser
extends ComboboxWithBrowseButton
implements ItemListener,
ItemSelectable {
    private List<ItemListener> myListeners = Lists.newArrayList();
    private boolean myResolveSystemImageSkins;

    public SkinChooser(@Nullable Project project, boolean resolveSystemImageSkins) {
        this.myResolveSystemImageSkins = resolveSystemImageSkins;
        this.setItems(this.getSkins());
        this.getComboBox().setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                File skinFile = value == null ? AvdWizardUtils.NO_SKIN : (File)value;
                String skinPath = skinFile.getPath();
                if (FileUtil.filesEqual((File)skinFile, (File)AvdWizardUtils.NO_SKIN)) {
                    this.append("No Skin");
                } else if (skinPath.contains("/sdk/platforms/")) {
                    this.append(skinPath.replaceAll(".*/sdk/platforms/(.*)/skins/(.*)", "$2 ($1)"));
                } else if (skinPath.contains("/sdk/system-images/")) {
                    this.append(skinPath.replaceAll(".*/sdk/system-images/(.*)/(.*)/(.*)/skins/(.*)", "$4 ($1 $3)"));
                } else {
                    this.append(skinFile.getName());
                }
            }
        });
        FileChooserDescriptor skinChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        this.addBrowseFolderListener("Select Custom Skin", "Select the directory containing your custom skin definition", project, skinChooserDescriptor, (TextComponentAccessor)new TextComponentAccessor<JComboBox>(){

            public String getText(JComboBox component2) {
                return ((File)component2.getSelectedItem()).getPath();
            }

            public void setText(JComboBox component2, @NotNull String text) {
                List items = SkinChooser.this.getSkins();
                File f = new File(text);
                items.add(f);
                SkinChooser.this.setItems(items);
                SkinChooser.this.getComboBox().setSelectedItem(f);
            }
        });
        this.getComboBox().addItemListener(this);
        this.setTextFieldPreferredWidth(20);
    }

    private void setItems(List<File> items) {
        this.getComboBox().setModel(new CollectionComboBoxModel(items));
    }

    private List<File> getSkins() {
        List<Device> devices = DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices();
        TreeSet result = Sets.newTreeSet();
        for (Device device : devices) {
            File skinFile = AvdWizardUtils.resolveSkinPath(device.getDefaultHardware().getSkinFile(), null, FileOpUtils.create());
            if (skinFile == null || !skinFile.exists()) continue;
            result.add(skinFile);
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SkinChooser.class);
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        for (IAndroidTarget target : sdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargets((ProgressIndicator)progress)) {
            Arrays.stream(target.getSkins()).map(this::resolve).forEach(result::add);
        }
        for (ISystemImage img : sdkHandler.getSystemImageManager((ProgressIndicator)progress).getImages()) {
            Arrays.stream(img.getSkins()).map(this::resolve).forEach(result::add);
        }
        ArrayList resultList = Lists.newArrayList();
        resultList.add(AvdWizardUtils.NO_SKIN);
        resultList.addAll(result);
        return resultList;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemEvent newEvent = new ItemEvent(this, e.getID(), e.getItem(), e.getStateChange());
        for (ItemListener listener : this.myListeners) {
            listener.itemStateChanged(newEvent);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.getComboBox().getSelectedObjects();
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.getComboBox().addItemListener(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.getComboBox().removeItemListener(l);
    }

    @Nullable
    private File resolve(@Nullable File skinFile) {
        if (skinFile == null) {
            return null;
        }
        if (this.myResolveSystemImageSkins) {
            return AvdWizardUtils.resolveSkinPath(skinFile, null, FileOpUtils.create());
        }
        return new File(skinFile.getName());
    }
}

