/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.error.IssueModel;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.util.IconUtil;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class IssueNotificationAction
extends AnAction {
    public static final String NO_ISSUE = "No Issue";
    public static final String SHOW_ISSUE = "Show Warnings and Errors";
    private static final Icon DISABLED_ICON = IconUtil.desaturate((Icon)AndroidIcons.Issue.Error);
    private final DesignSurface mySurface;

    public IssueNotificationAction(@NotNull DesignSurface surface) {
        super(NO_ISSUE, NO_ISSUE, null);
        this.mySurface = surface;
        this.setDefaultIcon(false);
        this.getTemplatePresentation().setIcon(IssueNotificationAction.getIssueTypeIcon(this.mySurface.getIssueModel()));
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        IssueModel issueModel = this.mySurface.getIssueModel();
        int markerCount = issueModel.getIssueCount();
        presentation.setText(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
        presentation.setDescription(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
        presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.SHOW_LINT_MESSAGES);
        this.mySurface.setShowIssuePanel(true);
    }

    @NotNull
    private static Icon getIssueTypeIcon(@NotNull IssueModel issueModel) {
        Icon icon = issueModel.getErrorCount() > 0 ? AndroidIcons.Issue.Error : (issueModel.getWarningCount() > 0 ? AndroidIcons.Issue.Warning : (issueModel.getIssueCount() > 0 ? AndroidIcons.Issue.Info : DISABLED_ICON));
        return icon;
    }
}

