/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.ZoomType;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class SetZoomAction
extends AnAction {
    @NotNull
    protected final DesignSurface mySurface;
    @NotNull
    private final ZoomType myType;

    public SetZoomAction(@NotNull DesignSurface surface, @NotNull ZoomType type) {
        super(type.getLabel());
        this.myType = type;
        this.mySurface = surface;
        this.getTemplatePresentation().setIcon(type.getIcon());
    }

    public void actionPerformed(AnActionEvent e) {
        switch (this.myType) {
            case ACTUAL: {
                NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.ZOOM_ACTUAL);
                break;
            }
            case IN: {
                NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.ZOOM_IN);
                break;
            }
            case OUT: {
                NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.ZOOM_OUT);
                break;
            }
            case FIT_INTO: 
            case FIT: {
                NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.ZOOM_FIT);
                break;
            }
        }
        this.mySurface.zoom(this.myType);
    }
}

