/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import com.android.sdklib.devices.State;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.common.analytics.NlUsageTracker;
import com.android.tools.idea.common.analytics.NopTracker;
import com.android.tools.idea.common.analytics.UsageTrackerUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.palette.PaletteMode;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.google.wireless.android.sdk.stats.LayoutEditorState;
import com.google.wireless.android.sdk.stats.LayoutFavoriteAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutPaletteEvent;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlUsageTrackerManager
implements NlUsageTracker {
    static final NlUsageTracker NOP_TRACKER = new NopTracker();
    private static final int LOG_RENDER_PERCENT = 10;
    private static final Cache<DesignSurface, NlUsageTracker> sTrackersCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static final Executor ourExecutorService = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10));
    private static final Random sRandom = new Random();
    private final Executor myExecutor;
    private final WeakReference<DesignSurface> myDesignSurfaceRef;
    private final UsageTracker myUsageTracker;

    NlUsageTrackerManager(@NotNull Executor executor, @Nullable DesignSurface surface, @NotNull UsageTracker usageTracker) {
        this.myExecutor = executor;
        this.myDesignSurfaceRef = new WeakReference<DesignSurface>(surface);
        this.myUsageTracker = usageTracker;
    }

    @NotNull
    static NlUsageTracker getInstanceInner(@Nullable DesignSurface surface) {
        if (surface == null) {
            return NOP_TRACKER;
        }
        try {
            return (NlUsageTracker)sTrackersCache.get((Object)surface, () -> new NlUsageTrackerManager(ourExecutorService, surface, UsageTracker.getInstance()));
        }
        catch (ExecutionException e) {
            assert (false);
            return NOP_TRACKER;
        }
    }

    @NotNull
    public static NlUsageTracker getInstance(@Nullable DesignSurface surface) {
        return UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn() ? NlUsageTrackerManager.getInstanceInner(surface) : NOP_TRACKER;
    }

    public static void setInstanceForTest(@NotNull DesignSurface surface, @NotNull NlUsageTracker tracker) {
        sTrackersCache.put((Object)surface, (Object)tracker);
    }

    public static void cleanAfterTesting(@NotNull DesignSurface surface) {
        sTrackersCache.put((Object)surface, (Object)NOP_TRACKER);
        sTrackersCache.invalidate((Object)surface);
    }

    @NotNull
    static LayoutEditorState getState(@Nullable DesignSurface surface) {
        Configuration configuration;
        LayoutEditorState.Builder builder = LayoutEditorState.newBuilder();
        if (surface == null) {
            return builder.build();
        }
        switch (surface.getLayoutType()) {
            case LAYOUT: {
                builder.setType(LayoutEditorState.Type.LAYOUT);
                break;
            }
            case MENU: {
                builder.setType(LayoutEditorState.Type.MENU);
                break;
            }
            case PREFERENCE_SCREEN: {
                builder.setType(LayoutEditorState.Type.PREFERENCE_SCREEN);
                break;
            }
            case VECTOR: {
                break;
            }
        }
        double scale = surface.getScale();
        if (SystemInfo.isMac && UIUtil.isRetina()) {
            scale *= 2.0;
        }
        if ((configuration = surface.getConfiguration()) != null) {
            State deviceState = configuration.getDeviceState();
            if (deviceState != null) {
                switch (deviceState.getOrientation()) {
                    case PORTRAIT: {
                        builder.setConfigOrientation(LayoutEditorState.Orientation.PORTRAIT);
                        break;
                    }
                    case LANDSCAPE: {
                        builder.setConfigOrientation(LayoutEditorState.Orientation.LANDSCAPE);
                        break;
                    }
                }
            }
            if (configuration.getTarget() != null) {
                builder.setConfigApiLevel(configuration.getTarget().getVersion().getApiString());
            }
        }
        if (scale >= 0.0) {
            builder.setConfigZoomLevel((int)(scale * 100.0));
        }
        if (surface instanceof NlDesignSurface) {
            builder.setMode(((NlDesignSurface)surface).isPreviewSurface() ? LayoutEditorState.Mode.PREVIEW_MODE : LayoutEditorState.Mode.DESIGN_MODE);
            switch (((NlDesignSurface)surface).getScreenMode()) {
                case SCREEN_ONLY: {
                    builder.setSurfaces(LayoutEditorState.Surfaces.SCREEN_SURFACE);
                    break;
                }
                case BLUEPRINT_ONLY: {
                    builder.setSurfaces(LayoutEditorState.Surfaces.BLUEPRINT_SURFACE);
                    break;
                }
                case BOTH: {
                    builder.setSurfaces(LayoutEditorState.Surfaces.BOTH);
                }
            }
        }
        return builder.build();
    }

    boolean shouldLog(int percent) {
        return sRandom.nextInt(100) >= 100 - percent - 1;
    }

    private void logStudioEvent(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType, @Nullable Consumer<LayoutEditorEvent.Builder> consumer) {
        try {
            this.myExecutor.execute(() -> {
                LayoutEditorEvent.Builder builder = LayoutEditorEvent.newBuilder().setType(eventType).setState(NlUsageTrackerManager.getState((DesignSurface)this.myDesignSurfaceRef.get()));
                if (consumer != null) {
                    consumer.accept(builder);
                }
                AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(builder.build());
                this.myUsageTracker.log(studioEvent);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void logAction(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType) {
        assert (!LayoutEditorEvent.LayoutEditorEventType.RENDER.equals((Object)eventType)) : "RENDER actions should be logged through logRenderResult";
        assert (!LayoutEditorEvent.LayoutEditorEventType.DROP_VIEW_FROM_PALETTE.equals((Object)eventType)) : "DROP_VIEW_FROM_PALETTE actions should be logged through logDropFromPalette";
        assert (!LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE.equals((Object)eventType)) : "DROP_VIEW_FROM_PALETTE actions should be logged through logPropertyChange";
        assert (!LayoutEditorEvent.LayoutEditorEventType.FAVORITE_CHANGE.equals((Object)eventType)) : "FAVORITE_CHANGE actions should be logged through logFavoritesChange";
        this.logStudioEvent(eventType, null);
    }

    @Override
    public void logRenderResult(@Nullable LayoutEditorRenderResult.Trigger trigger, @NotNull RenderResult result, long totalRenderTimeMs) {
        if (!this.shouldLog(10)) {
            return;
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.RENDER, event -> {
            LayoutEditorRenderResult.Builder builder = LayoutEditorRenderResult.newBuilder().setResultCode(result.getRenderResult().getStatus().ordinal()).setTotalRenderTimeMs(totalRenderTimeMs);
            if (trigger != null) {
                builder.setTrigger(trigger);
            }
            builder.setComponentCount((int)result.getRootViews().stream().flatMap(s -> Stream.concat(s.getChildren().stream(), Stream.of(s))).count());
            RenderErrorModel errorModel = RenderErrorModelFactory.createErrorModel(result, null);
            builder.setTotalIssueCount(errorModel.getIssues().size());
            if (!errorModel.getIssues().isEmpty()) {
                int errorCount = 0;
                int fidelityWarningCount = 0;
                for (RenderErrorModel.Issue issue2 : errorModel.getIssues()) {
                    if (HighlightSeverity.ERROR.getName().equals(issue2.getSeverity().getName())) {
                        ++errorCount;
                        continue;
                    }
                    if (!issue2.getSummary().startsWith("Layout fid")) continue;
                    ++fidelityWarningCount;
                }
                builder.setErrorCount(errorCount).setFidelityWarningCount(fidelityWarningCount);
            }
            event.setRenderResult(builder.build());
        });
    }

    @Override
    public void logDropFromPalette(@NotNull String viewTagName, @NotNull String representation, @NotNull PaletteMode paletteMode, @NotNull String selectedGroup, int filterMatches) {
        LayoutPaletteEvent.Builder builder = LayoutPaletteEvent.newBuilder().setView(UsageTrackerUtil.convertTagName(viewTagName)).setViewOption(UsageTrackerUtil.convertViewOption(viewTagName, representation)).setSelectedGroup(UsageTrackerUtil.convertGroupName(selectedGroup)).setSearchOption(UsageTrackerUtil.convertFilterMatches(filterMatches)).setViewType(UsageTrackerUtil.convertPaletteMode(paletteMode));
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.DROP_VIEW_FROM_PALETTE, event -> event.setPaletteEvent(builder));
    }

    @Override
    public void logPropertyChange(@NotNull NlProperty property, @NotNull NlPropertiesPanel.PropertiesViewMode propertiesMode, int filterMatches) {
        LayoutAttributeChangeEvent.Builder builder = LayoutAttributeChangeEvent.newBuilder().setAttribute(UsageTrackerUtil.convertAttribute(property)).setSearchOption(UsageTrackerUtil.convertFilterMatches(filterMatches)).setViewType(UsageTrackerUtil.convertPropertiesMode(propertiesMode));
        for (NlComponent component2 : property.getComponents()) {
            builder.addView(UsageTrackerUtil.convertTagName(component2.getTagName()));
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE, event -> event.setAttributeChangeEvent(builder));
    }

    @Override
    public void logFavoritesChange(@NotNull String addedPropertyName, @NotNull String removedPropertyName, @NotNull List<String> currentFavorites, @NotNull AndroidFacet facet) {
        LayoutFavoriteAttributeChangeEvent.Builder builder = LayoutFavoriteAttributeChangeEvent.newBuilder();
        if (!addedPropertyName.isEmpty()) {
            builder.setAdded(UsageTrackerUtil.convertAttribute(addedPropertyName, facet));
        }
        if (!removedPropertyName.isEmpty()) {
            builder.setRemoved(UsageTrackerUtil.convertAttribute(removedPropertyName, facet));
        }
        for (String propertyName : currentFavorites) {
            builder.addActive(UsageTrackerUtil.convertAttribute(propertyName, facet));
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.FAVORITE_CHANGE, event -> event.setFavoriteChangeEvent(builder));
    }
}

