/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import com.android.tools.idea.uibuilder.palette.PaletteMode;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidAttribute;
import com.google.wireless.android.sdk.stats.AndroidView;
import com.google.wireless.android.sdk.stats.LayoutAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutPaletteEvent;
import com.google.wireless.android.sdk.stats.SearchOption;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageTrackerUtil {
    private static final Pattern STYLE_PATTERN = Pattern.compile("style=\"(.*)\"");
    private static final Pattern INPUT_STYLE_PATTERN = Pattern.compile("android:inputType=\"(.*)\"");
    private static final Pattern ORIENTATION_PATTERN = Pattern.compile("android:orientation=\"(.*)\"");
    private static final Map<String, LayoutPaletteEvent.ViewOption> PALETTE_VIEW_OPTION_MAP = ImmutableMap.builder().put((Object)"textPassword", (Object)LayoutPaletteEvent.ViewOption.PASSWORD).put((Object)"numberPassword", (Object)LayoutPaletteEvent.ViewOption.PASSWORD_NUMERIC).put((Object)"textEmailAddress", (Object)LayoutPaletteEvent.ViewOption.EMAIL).put((Object)"phone", (Object)LayoutPaletteEvent.ViewOption.PHONE).put((Object)"textPostalAddress", (Object)LayoutPaletteEvent.ViewOption.POSTAL_ADDRESS).put((Object)"textMultiLine", (Object)LayoutPaletteEvent.ViewOption.MULTILINE_TEXT).put((Object)"time", (Object)LayoutPaletteEvent.ViewOption.TIME_EDITOR).put((Object)"date", (Object)LayoutPaletteEvent.ViewOption.DATE_EDITOR).put((Object)"number", (Object)LayoutPaletteEvent.ViewOption.NUMBER).put((Object)"numberSigned", (Object)LayoutPaletteEvent.ViewOption.SIGNED_NUMBER).put((Object)"numberDecimal", (Object)LayoutPaletteEvent.ViewOption.DECIMAL_NUMBER).build();
    static final String CUSTOM_NAME = "CUSTOM";

    private UsageTrackerUtil() {
    }

    @NotNull
    static AndroidAttribute convertAttribute(@NotNull NlProperty property) {
        AndroidFacet facet = property.getModel().getFacet();
        AttributeDefinition definition = property.getDefinition();
        String libraryName = definition != null ? definition.getLibraryName() : null;
        AndroidAttribute.AttributeNamespace namespace = UsageTrackerUtil.convertNamespace(property.getNamespace());
        return AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(property.getName(), namespace, libraryName, facet)).setAttributeNamespace(namespace).build();
    }

    @NotNull
    static AndroidAttribute convertAttribute(@NotNull String attributeName, @NotNull AndroidFacet facet) {
        AndroidAttribute.AttributeNamespace namespace = null;
        if (attributeName.startsWith("tools:")) {
            namespace = AndroidAttribute.AttributeNamespace.TOOLS;
            attributeName = StringUtil.trimStart((String)attributeName, (String)"tools:");
        }
        NamespaceAndLibraryNamePair lookup = UsageTrackerUtil.lookupAttributeResource(facet, attributeName);
        if (namespace == null) {
            namespace = lookup.getNamespace();
        }
        return AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(attributeName, lookup.getNamespace(), lookup.getLibraryName(), facet)).setAttributeNamespace(namespace).build();
    }

    @NotNull
    static AndroidAttribute.AttributeNamespace convertNamespace(@Nullable String namespace) {
        if (StringUtil.isEmpty((String)namespace)) {
            return AndroidAttribute.AttributeNamespace.ANDROID;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                return AndroidAttribute.AttributeNamespace.TOOLS;
            }
            case "http://schemas.android.com/apk/res/android": {
                return AndroidAttribute.AttributeNamespace.ANDROID;
            }
        }
        return AndroidAttribute.AttributeNamespace.APPLICATION;
    }

    @NotNull
    static LayoutPaletteEvent.ViewGroup convertGroupName(@NotNull String groupName) {
        switch (groupName) {
            case "All": {
                return LayoutPaletteEvent.ViewGroup.ALL_GROUPS;
            }
            case "Widgets": {
                return LayoutPaletteEvent.ViewGroup.WIDGETS;
            }
            case "Text": {
                return LayoutPaletteEvent.ViewGroup.TEXT;
            }
            case "Layouts": {
                return LayoutPaletteEvent.ViewGroup.LAYOUTS;
            }
            case "Containers": {
                return LayoutPaletteEvent.ViewGroup.CONTAINERS;
            }
            case "Images": {
                return LayoutPaletteEvent.ViewGroup.IMAGES;
            }
            case "Date": {
                return LayoutPaletteEvent.ViewGroup.DATES;
            }
            case "Transitions": {
                return LayoutPaletteEvent.ViewGroup.TRANSITIONS;
            }
            case "Advanced": {
                return LayoutPaletteEvent.ViewGroup.ADVANCED;
            }
            case "Google": {
                return LayoutPaletteEvent.ViewGroup.GOOGLE;
            }
            case "Design": {
                return LayoutPaletteEvent.ViewGroup.DESIGN;
            }
            case "AppCompat": {
                return LayoutPaletteEvent.ViewGroup.APP_COMPAT;
            }
        }
        return LayoutPaletteEvent.ViewGroup.CUSTOM;
    }

    @NotNull
    static LayoutPaletteEvent.ViewOption convertViewOption(@NotNull String tagName, @NotNull String representation) {
        switch (tagName) {
            case "ProgressBar": {
                return UsageTrackerUtil.convertProgressBarViewOption(representation);
            }
            case "SeekBar": {
                return UsageTrackerUtil.convertSeekBarViewOption(representation);
            }
            case "EditText": {
                return UsageTrackerUtil.convertEditTextViewOption(representation);
            }
            case "LinearLayout": {
                return UsageTrackerUtil.convertLinearLayoutViewOption(representation);
            }
        }
        return LayoutPaletteEvent.ViewOption.NORMAL;
    }

    @NotNull
    static LayoutPaletteEvent.ViewType convertPaletteMode(@NotNull PaletteMode paletteMode) {
        switch (paletteMode) {
            case LARGE_ICONS: {
                return LayoutPaletteEvent.ViewType.LARGE_IONS;
            }
            case SMALL_ICONS: {
                return LayoutPaletteEvent.ViewType.SMALL_ICONS;
            }
        }
        return LayoutPaletteEvent.ViewType.ICON_AND_NAME;
    }

    @NotNull
    static LayoutAttributeChangeEvent.ViewType convertPropertiesMode(@NotNull NlPropertiesPanel.PropertiesViewMode propertiesMode) {
        switch (propertiesMode) {
            case TABLE: {
                return LayoutAttributeChangeEvent.ViewType.PROPERTY_TABLE;
            }
        }
        return LayoutAttributeChangeEvent.ViewType.INSPECTOR;
    }

    @NotNull
    static SearchOption convertFilterMatches(int matches) {
        if (matches < 1) {
            return SearchOption.NONE;
        }
        if (matches > 1) {
            return SearchOption.MULTIPLE_MATCHES;
        }
        return SearchOption.SINGLE_MATCH;
    }

    @NotNull
    static LayoutPaletteEvent.ViewOption convertProgressBarViewOption(@NotNull String representation) {
        String styleValue = UsageTrackerUtil.getStyleValue(representation);
        if (styleValue == null || styleValue.equals("?android:attr/progressBarStyle")) {
            return LayoutPaletteEvent.ViewOption.NORMAL;
        }
        if (styleValue.equals("?android:attr/progressBarStyleHorizontal")) {
            return LayoutPaletteEvent.ViewOption.HORIZONTAL_PROGRESS_BAR;
        }
        return LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }

    @NotNull
    static LayoutPaletteEvent.ViewOption convertSeekBarViewOption(@NotNull String representation) {
        String styleValue = UsageTrackerUtil.getStyleValue(representation);
        if (styleValue == null) {
            return LayoutPaletteEvent.ViewOption.NORMAL;
        }
        if (styleValue.equals("@style/Widget.AppCompat.SeekBar.Discrete")) {
            return LayoutPaletteEvent.ViewOption.DISCRETE_SEEK_BAR;
        }
        return LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }

    @NotNull
    static LayoutPaletteEvent.ViewOption convertEditTextViewOption(@NotNull String representation) {
        Matcher matcher = INPUT_STYLE_PATTERN.matcher(representation);
        if (!matcher.find()) {
            return LayoutPaletteEvent.ViewOption.NORMAL;
        }
        LayoutPaletteEvent.ViewOption viewOption = PALETTE_VIEW_OPTION_MAP.get(matcher.group(1));
        return viewOption != null ? viewOption : LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }

    @NotNull
    static LayoutPaletteEvent.ViewOption convertLinearLayoutViewOption(@NotNull String representation) {
        Matcher matcher = ORIENTATION_PATTERN.matcher(representation);
        if (!matcher.find()) {
            return LayoutPaletteEvent.ViewOption.HORIZONTAL_LINEAR_LAYOUT;
        }
        String orientation = matcher.group(1);
        if (orientation.equals("horizontal")) {
            return LayoutPaletteEvent.ViewOption.HORIZONTAL_LINEAR_LAYOUT;
        }
        if (orientation.equals("vertical")) {
            return LayoutPaletteEvent.ViewOption.VERTICAL_LINEAR_LAYOUT;
        }
        return LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }

    @NotNull
    static String convertAttributeName(@NotNull String attributeName, @NotNull AndroidAttribute.AttributeNamespace namespace, @Nullable String libraryName, @NotNull AndroidFacet facet) {
        switch (namespace) {
            case ANDROID: {
                return attributeName;
            }
            case APPLICATION: {
                return libraryName != null && UsageTrackerUtil.acceptedGoogleLibraryNamespace(libraryName) ? attributeName : CUSTOM_NAME;
            }
            case TOOLS: {
                NamespaceAndLibraryNamePair lookup = UsageTrackerUtil.lookupAttributeResource(facet, attributeName);
                assert (lookup.getNamespace() != AndroidAttribute.AttributeNamespace.TOOLS);
                return UsageTrackerUtil.convertAttributeName(attributeName, lookup.getNamespace(), lookup.getLibraryName(), facet);
            }
        }
        return CUSTOM_NAME;
    }

    @NotNull
    static AndroidView convertTagName(@NotNull String tagName) {
        tagName = UsageTrackerUtil.acceptedGoogleTagNamespace(tagName) ? StringUtil.getShortName((String)tagName, (char)'.') : CUSTOM_NAME;
        return AndroidView.newBuilder().setTagName(tagName).build();
    }

    @Nullable
    static String getStyleValue(@NotNull String representation) {
        Matcher matcher = STYLE_PATTERN.matcher(representation);
        return matcher.find() ? matcher.group(1) : null;
    }

    static boolean acceptedGoogleLibraryNamespace(@NotNull String libraryName) {
        return libraryName.startsWith("com.android.") || libraryName.startsWith("com.google.") || libraryName.startsWith("constraint-layout") || libraryName.startsWith("flexbox") || libraryName.startsWith("design-") || libraryName.startsWith("appcompat-v7-") || libraryName.startsWith("cardview-v7-") || libraryName.startsWith("gridlayout-v7") || libraryName.startsWith("recyclerview-v7") || libraryName.startsWith("coordinatorlayout-v7") || libraryName.startsWith("play-services-maps-") || libraryName.startsWith("play-services-ads-") || libraryName.startsWith("leanback-v17-");
    }

    static boolean acceptedGoogleTagNamespace(@NotNull String fullyQualifiedTagName) {
        return fullyQualifiedTagName.indexOf(46) < 0 || fullyQualifiedTagName.startsWith("com.android.") || fullyQualifiedTagName.startsWith("com.google.") || fullyQualifiedTagName.startsWith("android.support.") || fullyQualifiedTagName.startsWith("android.databinding.");
    }

    @NotNull
    static NamespaceAndLibraryNamePair lookupAttributeResource(@NotNull AndroidFacet facet, @NotNull String attributeName) {
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet);
        SystemResourceManager systemResourceManager = resourceManagers.getSystemResourceManager();
        if (systemResourceManager == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        AttributeDefinitions localAttributeDefinitions = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttributeDefinitions = ((ResourceManager)systemResourceManager).getAttributeDefinitions();
        if (systemAttributeDefinitions != null && systemAttributeDefinitions.getAttributeNames().contains(attributeName)) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.ANDROID);
        }
        if (localAttributeDefinitions == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        AttributeDefinition definition = localAttributeDefinitions.getAttrDefByName(attributeName);
        if (definition == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION, definition.getLibraryName());
    }

    static class NamespaceAndLibraryNamePair {
        private final AndroidAttribute.AttributeNamespace myNamespace;
        private final String myLibraryName;

        NamespaceAndLibraryNamePair(@NotNull AndroidAttribute.AttributeNamespace namespace) {
            this(namespace, null);
        }

        NamespaceAndLibraryNamePair(@NotNull AndroidAttribute.AttributeNamespace namespace, @Nullable String libraryName) {
            this.myNamespace = namespace;
            this.myLibraryName = libraryName;
        }

        @NotNull
        public AndroidAttribute.AttributeNamespace getNamespace() {
            return this.myNamespace;
        }

        @Nullable
        public String getLibraryName() {
            return this.myLibraryName;
        }
    }
}

