/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.command;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NlWriteCommandAction
implements Runnable {
    private final List<NlComponent> myComponents;
    private final String myName;
    private final Runnable myRunnable;
    private final NlModel myModel;

    public NlWriteCommandAction(@NotNull List<NlComponent> components, @NotNull String name, @NotNull Runnable runnable) {
        NlWriteCommandAction.checkComponents(components);
        this.myComponents = components;
        this.myName = name;
        this.myRunnable = runnable;
        this.myModel = this.myComponents.get(0).getModel();
    }

    private static void checkComponents(@NotNull List<NlComponent> components) {
        int size = components.size();
        switch (size) {
            case 0: {
                throw new IllegalArgumentException();
            }
            case 1: {
                break;
            }
            default: {
                NlModel model = components.get(0).getModel();
                for (NlComponent component2 : components.subList(1, size)) {
                    if (component2.getModel() == model) continue;
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public static void run(@NotNull NlComponent component2, @NotNull String name, @NotNull Runnable runnable) {
        new NlWriteCommandAction(Collections.singletonList(component2), name, runnable).run();
    }

    public static void run(@NotNull List<NlComponent> components, @NotNull String name, @NotNull Runnable runnable) {
        new NlWriteCommandAction(components, name, runnable).run();
    }

    @Override
    public void run() {
        new WriteCommandActionImpl().execute();
    }

    private final class WriteCommandActionImpl
    extends WriteCommandAction.Simple<Void> {
        private WriteCommandActionImpl() {
            super(NlWriteCommandAction.this.myModel.getProject(), NlWriteCommandAction.this.myName, new PsiFile[]{NlWriteCommandAction.this.myModel.getFile()});
        }

        protected void run() throws Throwable {
            NlWriteCommandAction.this.myRunnable.run();
            ViewEditor editor = NlWriteCommandAction.this.myModel.getSurface().getViewEditor();
            NlWriteCommandAction.this.myComponents.forEach(component2 -> {
                this.cleanUpAttributes(editor, (NlComponent)component2);
                this.reformatAndRearrange((NlComponent)component2);
            });
        }

        private void cleanUpAttributes(@Nullable ViewEditor editor, @NotNull NlComponent component2) {
            if (editor == null) {
                return;
            }
            ViewGroupHandler handler = ViewHandlerManager.get(this.getProject()).findLayoutHandler(component2, true);
            if (handler == null) {
                return;
            }
            handler.cleanUpAttributes(editor, component2);
        }

        private void reformatAndRearrange(@NotNull NlComponent component2) {
            XmlTag tag = component2.getTag();
            if (tag == null) {
                Logger.getInstance(NlWriteCommandAction.class).warn("Not reformatting " + component2 + " because its tag is null");
                return;
            }
            if (tag.getContainingFile().getVirtualFile() == null) {
                Logger.getInstance(NlWriteCommandAction.class).warn("Not reformatting " + component2 + " because its virtual file is null");
                return;
            }
            TemplateUtils.reformatAndRearrange(this.getProject(), (PsiElement)tag);
        }
    }
}

