/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.idea.common.editor.ActionsToolbar;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionManager<S extends DesignSurface> {
    protected final S mySurface;

    public ActionManager(@NotNull S surface) {
        this.mySurface = surface;
    }

    public abstract void registerActions(@NotNull JComponent var1);

    protected static void registerAction(@NotNull AnAction action, @NonNls String actionId, @NotNull JComponent component2) {
        action.registerCustomShortcutSet(com.intellij.openapi.actionSystem.ActionManager.getInstance().getAction(actionId).getShortcutSet(), component2);
    }

    @NotNull
    public JComponent createToolbar(@NotNull NlModel model) {
        ActionsToolbar actionsToolbar = this.createActionsToolbar();
        actionsToolbar.setModel(model);
        return actionsToolbar.getToolbarComponent();
    }

    @NotNull
    protected ActionsToolbar createActionsToolbar() {
        return new ActionsToolbar((DesignSurface)this.mySurface);
    }

    public void showPopup(@NotNull MouseEvent event) {
        int y;
        NlComponent component2 = null;
        int x = event.getX();
        SceneView sceneView = ((DesignSurface)this.mySurface).getSceneView(x, y = event.getY());
        if (sceneView == null) {
            sceneView = ((DesignSurface)this.mySurface).getCurrentSceneView();
        }
        if (sceneView != null) {
            component2 = Coordinates.findComponent(sceneView, x, y);
        }
        this.showPopup(event, component2);
    }

    public void showPopup(@NotNull MouseEvent event, @Nullable NlComponent leafComponent) {
        com.intellij.openapi.actionSystem.ActionManager actionManager = com.intellij.openapi.actionSystem.ActionManager.getInstance();
        DefaultActionGroup group = this.createPopupMenu(actionManager, leafComponent);
        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("LayoutEditor", (ActionGroup)group);
        Object invoker = event.getSource() instanceof Component ? (Component)event.getSource() : this.mySurface;
        popupMenu.getComponent().show((Component)invoker, event.getX(), event.getY());
    }

    @NotNull
    protected abstract DefaultActionGroup createPopupMenu(@NotNull com.intellij.openapi.actionSystem.ActionManager var1, @Nullable NlComponent var2);

    public abstract void addActions(@NotNull DefaultActionGroup var1, @Nullable NlComponent var2, @Nullable NlComponent var3, @NotNull List<NlComponent> var4, boolean var5);
}

