/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.idea.common.editor.ToolbarActionGroups;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.PanZoomListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionsToolbar
implements DesignSurfaceListener,
Disposable,
ModelListener,
PanZoomListener,
ConfigurationListener {
    private static final int CONFIGURATION_UPDATE_FLAGS = 34;
    private final DesignSurface mySurface;
    private NlModel myModel;
    private JComponent myToolbarComponent;
    private ActionToolbar myNorthToolbar;
    private ActionToolbar myEastToolbar;
    private final DefaultActionGroup myDynamicGroup = new DefaultActionGroup();

    public ActionsToolbar(DesignSurface surface) {
        this.mySurface = surface;
    }

    public void dispose() {
        this.myModel.removeListener(this);
        this.mySurface.removePanZoomListener(this);
        this.mySurface.removeListener(this);
        Configuration configuration = this.mySurface.getConfiguration();
        if (configuration != null) {
            configuration.removeListener(this);
        }
    }

    @NotNull
    public JComponent getToolbarComponent() {
        if (this.myToolbarComponent == null) {
            this.myToolbarComponent = this.createToolbarComponent();
            this.mySurface.addListener(this);
            this.mySurface.addPanZoomListener(this);
            Configuration configuration = this.mySurface.getConfiguration();
            if (configuration != null) {
                configuration.addListener(this);
            }
            this.updateActions();
        }
        return this.myToolbarComponent;
    }

    @NotNull
    private JComponent createToolbarComponent() {
        ToolbarActionGroups groups = this.mySurface.getLayoutType().getToolbarActionGroups(this.mySurface);
        this.myNorthToolbar = ActionsToolbar.createActionToolbar("NlConfigToolbar", groups.getNorthGroup());
        JComponent northToolbarComponent = this.myNorthToolbar.getComponent();
        northToolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        northToolbarComponent.setName("NlConfigToolbar");
        ActionToolbar centerToolbar = ActionsToolbar.createActionToolbar("NlLayoutToolbar", (ActionGroup)this.myDynamicGroup);
        JComponent centerToolbarComponent = centerToolbar.getComponent();
        centerToolbarComponent.setName("NlLayoutToolbar");
        this.myEastToolbar = ActionsToolbar.createActionToolbar("NlRhsToolbar", groups.getEastGroup());
        JComponent eastToolbarComponent = this.myEastToolbar.getComponent();
        eastToolbarComponent.setName("NlRhsToolbar");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createBorder((int)8));
        panel.add((Component)northToolbarComponent, "North");
        panel.add((Component)centerToolbarComponent, "Center");
        panel.add((Component)eastToolbarComponent, "East");
        return panel;
    }

    @NotNull
    private static ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(place, group, true);
        toolbar.setLayoutPolicy(1);
        return toolbar;
    }

    public void updateActions() {
        SceneView view = this.mySurface.getCurrentSceneView();
        if (view != null) {
            SelectionModel selectionModel = view.getSelectionModel();
            Object selection = selectionModel.getSelection();
            if (selection.isEmpty()) {
                ImmutableList<NlComponent> roots = view.getModel().getComponents();
                if (roots.size() == 1) {
                    selection = Collections.singletonList(roots.get(0));
                } else {
                    this.myModel.addListener(this);
                    return;
                }
            }
            this.updateActions((List<NlComponent>)selection);
        }
    }

    public void setModel(NlModel model) {
        this.myModel = model;
    }

    @Nullable
    private static NlComponent findSharedParent(@NotNull List<NlComponent> newSelection) {
        NlComponent parent = null;
        for (NlComponent selected : newSelection) {
            if (parent == null) {
                parent = selected.getParent();
                if (newSelection.size() != 1 || !selected.isRoot() || parent != null && !parent.isRoot()) continue;
                return selected;
            }
            if (parent == selected.getParent()) continue;
            parent = null;
            break;
        }
        return parent;
    }

    private void updateActions(@NotNull List<NlComponent> newSelection) {
        SceneView screenView = this.mySurface.getCurrentSceneView();
        if (screenView == null) {
            return;
        }
        this.myDynamicGroup.removeAll();
        NlComponent parent = ActionsToolbar.findSharedParent(newSelection);
        if (parent != null) {
            this.mySurface.getActionManager().addActions(this.myDynamicGroup, null, parent, newSelection, true);
        }
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
        assert (surface == this.mySurface);
        if (!newSelection.isEmpty()) {
            this.updateActions(newSelection);
        } else {
            this.updateActions();
        }
    }

    @Override
    public void sceneChanged(@NotNull DesignSurface surface, @Nullable SceneView sceneView) {
        this.myNorthToolbar.updateActionsImmediately();
        this.updateActions();
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (this.myDynamicGroup.getChildrenCount() == 0) {
            this.myModel = model;
            this.updateActions();
        }
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component2) {
        return false;
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        this.updateActions();
        model.removeListener(this);
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
    }

    @Override
    public void zoomChanged(@NotNull DesignSurface surface) {
        this.myEastToolbar.updateActionsImmediately();
    }

    @Override
    public void panningChanged(@NotNull AdjustmentEvent event) {
    }

    @Override
    public boolean changed(int flags) {
        if ((flags & 0x22) > 0 && this.myNorthToolbar != null) {
            this.myNorthToolbar.updateActionsImmediately();
        }
        return true;
    }
}

