/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.editor.NlEditor;
import com.android.tools.idea.common.model.NlLayoutType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;

public class NlEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String DESIGNER_ID = "android-designer2";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, virtualFile);
        return psiFile instanceof XmlFile && NlLayoutType.supports((XmlFile)psiFile);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        return new NlEditor(file, project);
    }

    @NotNull
    public String getEditorTypeId() {
        return DESIGNER_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor() ? FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR : FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }
}

