/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.lint;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.psi.PsiElement;
import icons.AndroidIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LintAnnotationsModel {
    @Nullable
    private ListMultimap<NlComponent, IssueData> myIssues;
    private List<IssueData> myIssueList;

    @NotNull
    public Collection<NlComponent> getComponentsWithIssues() {
        return this.myIssues == null ? Collections.emptyList() : this.myIssues.keySet();
    }

    @Nullable
    public Icon getIssueIcon(@NotNull NlComponent component2) {
        return this.getIssueIcon(component2, true, false);
    }

    @Nullable
    public Icon getIssueIcon(@NotNull NlComponent component2, boolean smallSize, boolean selected) {
        if (this.myIssues == null) {
            return null;
        }
        List issueData = this.myIssues.get((Object)component2);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        IssueData max = LintAnnotationsModel.findHighestSeverityIssue(issueData);
        boolean isError = HighlightDisplayLevel.ERROR.equals(max.level);
        if (smallSize) {
            return isError ? AndroidIcons.Issue.ErrorBadge : AndroidIcons.Issue.WarningBadge;
        }
        if (selected) {
            return isError ? AndroidIcons.Issue.ErrorSelected : AndroidIcons.Issue.WarningSelected;
        }
        return isError ? AndroidIcons.Issue.Error : AndroidIcons.Issue.Warning;
    }

    @Nullable
    public String getIssueMessage(@NotNull NlComponent component2) {
        return this.getIssueMessage(component2, true);
    }

    @Nullable
    public String getIssueMessage(@NotNull NlComponent component2, boolean includeStaticDescription) {
        if (this.myIssues == null) {
            return null;
        }
        List issueData = this.myIssues.get((Object)component2);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        IssueData max = LintAnnotationsModel.findHighestSeverityIssue(issueData);
        if (includeStaticDescription) {
            return max.message + "<br><br>\n" + max.inspection.getStaticDescription();
        }
        return max.message;
    }

    private static IssueData findHighestSeverityIssue(List<IssueData> issueData) {
        return Collections.max(issueData);
    }

    public void addIssue(@NotNull NlComponent component2, @NotNull Issue issue2, @NotNull String message, @NotNull AndroidLintInspectionBase inspection, @NotNull HighlightDisplayLevel level, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @Nullable LintFix quickfixData) {
        if (issue2 == RtlDetector.COMPAT) {
            return;
        }
        if (this.myIssues == null) {
            this.myIssues = ArrayListMultimap.create();
            this.myIssueList = Lists.newArrayList();
        }
        IssueData data = new IssueData(component2, inspection, issue2, message, level, startElement, endElement, quickfixData);
        this.myIssues.put((Object)component2, (Object)data);
        this.myIssueList.add(data);
    }

    public int getIssueCount() {
        return this.myIssueList == null ? 0 : this.myIssueList.size();
    }

    @NotNull
    public List<IssueData> getIssues() {
        return this.myIssueList != null ? this.myIssueList : Collections.emptyList();
    }

    public static class IssueData
    implements Comparable<IssueData> {
        @NotNull
        public final AndroidLintInspectionBase inspection;
        @NotNull
        public final HighlightDisplayLevel level;
        @NotNull
        public final String message;
        @NotNull
        public final Issue issue;
        @NotNull
        public final PsiElement endElement;
        @NotNull
        public final PsiElement startElement;
        @NotNull
        public final NlComponent component;
        @Nullable
        public final LintFix quickfixData;

        private IssueData(@NotNull NlComponent component2, @NotNull AndroidLintInspectionBase inspection, @NotNull Issue issue2, @NotNull String message, @NotNull HighlightDisplayLevel level, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @Nullable LintFix quickfixData) {
            this.component = component2;
            this.inspection = inspection;
            this.issue = issue2;
            this.message = message;
            this.level = level;
            this.startElement = startElement;
            this.endElement = endElement;
            this.quickfixData = quickfixData;
        }

        @Override
        public int compareTo(@NotNull IssueData o) {
            return ComparisonChain.start().compare((Comparable)this.level.getSeverity(), (Comparable)o.level.getSeverity()).compare(this.issue.getPriority(), o.issue.getPriority()).compare((Comparable)o.issue.getDefaultSeverity(), (Comparable)this.issue.getDefaultSeverity()).result();
        }
    }
}

