/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import android.view.View;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.uibuilder.model.LayoutParamsManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributesTransaction
implements NlAttributesHolder {
    private final NlComponent myComponent;
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final HashMap<String, PendingAttribute> myPendingAttributes = new HashMap();
    private final HashMap<String, String> myOriginalValues;
    private final NlModel myModel;
    private boolean isValid = true;
    private boolean isSuccessful = false;
    @NotNull
    private WeakReference<View> myCachedView = new WeakReference<Object>(null);
    private boolean hasPendingRelayout;

    public AttributesTransaction(@NotNull NlComponent thisComponent) {
        this.myComponent = thisComponent;
        this.myModel = this.myComponent.getModel();
        List<AttributeSnapshot> attributes = this.myComponent.getAttributes();
        this.myOriginalValues = Maps.newHashMapWithExpectedSize((int)attributes.size());
        attributes.stream().forEach(attribute -> this.myOriginalValues.put(AttributesTransaction.attributeKey(attribute.namespace, attribute.name), attribute.value));
    }

    @NotNull
    private static String attributeKey(@Nullable String namespace, @NotNull String attribute) {
        return String.format("%s:%s", namespace, attribute);
    }

    private void applyAttributeToView(@NotNull PendingAttribute attribute, @NotNull ViewInfo viewInfo, NlModel model) {
        if (attribute.name.startsWith("layout_")) {
            String value = attribute.value;
            Object layoutParams = viewInfo.getLayoutParamsObject();
            Object viewObject = viewInfo.getViewObject();
            if (viewObject == null || layoutParams == null) {
                return;
            }
            boolean changed = LayoutParamsManager.setAttribute(layoutParams, StringUtil.trimStart((String)attribute.name, (String)"layout_"), value, model);
            this.hasPendingRelayout |= changed;
        }
    }

    private static void triggerViewRelayout(@NotNull View view) {
        view.setLayoutParams(view.getLayoutParams());
        view.forceLayout();
    }

    private void applyAllPendingAttributesToView(@NotNull ViewInfo viewInfo) {
        View cachedView = (View)viewInfo.getViewObject();
        this.myCachedView = new WeakReference<View>(cachedView);
        if (cachedView != null) {
            this.myPendingAttributes.values().stream().filter(Objects::nonNull).forEach(pendingAttribute -> this.applyAttributeToView((PendingAttribute)pendingAttribute, viewInfo, this.myModel));
            this.hasPendingRelayout = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String name, @Nullable String value) {
        this.myLock.writeLock().lock();
        try {
            assert (this.isValid);
            String key = AttributesTransaction.attributeKey(namespace, name);
            PendingAttribute attribute = this.myPendingAttributes.get(key);
            boolean modified = true;
            if (attribute != null) {
                if (StringUtil.equals((CharSequence)attribute.value, (CharSequence)value)) {
                    modified = false;
                } else {
                    attribute.value = value;
                }
            } else {
                attribute = new PendingAttribute(namespace, name, value);
                this.myPendingAttributes.put(key, attribute);
            }
            ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(this.myComponent);
            if (viewInfo != null) {
                View cachedView = (View)this.myCachedView.get();
                if (cachedView == viewInfo.getViewObject()) {
                    if (modified && cachedView != null) {
                        this.applyAttributeToView(attribute, viewInfo, this.myModel);
                    }
                } else {
                    this.applyAllPendingAttributesToView(viewInfo);
                }
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        this.myLock.readLock().lock();
        try {
            assert (this.isValid);
            PendingAttribute pendingAttribute = this.myPendingAttributes.get(AttributesTransaction.attributeKey(namespace, attribute));
            if (pendingAttribute != null) {
                String string = pendingAttribute.value;
                return string;
            }
            String string = this.myComponent.getAttribute(namespace, attribute);
            return string;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    @NotNull
    public NlComponent getComponent() {
        return this.myComponent;
    }

    private boolean finishTransaction() {
        assert (this.isValid);
        this.isValid = false;
        this.myComponent.myCurrentTransaction = null;
        boolean hadPendingChanges = !this.myPendingAttributes.isEmpty();
        this.myPendingAttributes.clear();
        this.myOriginalValues.clear();
        return hadPendingChanges;
    }

    public void apply() {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(this.myComponent);
        if (this.hasPendingRelayout && viewInfo != null) {
            View currentView = (View)viewInfo.getViewObject();
            if (currentView != this.myCachedView.get()) {
                this.applyAllPendingAttributesToView(NlComponentHelperKt.getViewInfo(this.myComponent));
            }
            AttributesTransaction.triggerViewRelayout((View)NlComponentHelperKt.getViewInfo(this.myComponent).getViewObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(this.myComponent);
        if (this.hasPendingRelayout && viewInfo != null) {
            View currentView = (View)viewInfo.getViewObject();
            if (currentView != this.myCachedView.get()) {
                this.applyAllPendingAttributesToView(NlComponentHelperKt.getViewInfo(this.myComponent));
            }
            AttributesTransaction.triggerViewRelayout((View)NlComponentHelperKt.getViewInfo(this.myComponent).getViewObject());
        }
        this.myLock.writeLock().lock();
        try {
            assert (this.isValid);
            if (!this.myComponent.getTag().isValid()) {
                boolean currentView = this.finishTransaction();
                return currentView;
            }
            if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                boolean currentView = (Boolean)ApplicationManager.getApplication().runWriteAction(this::commit);
                return currentView;
            }
            boolean modified = false;
            for (PendingAttribute attribute : this.myPendingAttributes.values()) {
                String originalValue = this.myOriginalValues.get(AttributesTransaction.attributeKey(attribute.namespace, attribute.name));
                String currentValue = this.myComponent.getAttribute(attribute.namespace, attribute.name);
                if (StringUtil.equals((CharSequence)currentValue, (CharSequence)attribute.value) || !StringUtil.equals((CharSequence)originalValue, (CharSequence)currentValue) && (StringUtil.isEmpty((String)attribute.value) || StringUtil.equals((CharSequence)originalValue, (CharSequence)attribute.value))) continue;
                modified = true;
                this.myComponent.setAttribute(attribute.namespace, attribute.name, attribute.value);
            }
            this.isSuccessful = true;
            this.finishTransaction();
            boolean bl = modified;
            return bl;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public boolean isComplete() {
        return !this.isValid;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public boolean rollback() {
        this.myLock.writeLock().lock();
        try {
            boolean bl = this.finishTransaction();
            return bl;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    private static class PendingAttribute {
        final String namespace;
        final String name;
        String value;

        private PendingAttribute(@Nullable String namespace, @NotNull String name, @Nullable String value) {
            this.namespace = namespace;
            this.name = name;
            this.value = value;
        }
    }
}

