/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Coordinates {
    public static final float DEFAULT_DENSITY = 160.0f;

    public static int getSwingX(@NotNull SceneView view, int androidX) {
        return view.getX() + view.getContentTranslationX() + (int)(view.getScale() * (double)androidX);
    }

    public static int getSwingY(@NotNull SceneView view, int androidY) {
        return view.getY() + view.getContentTranslationY() + (int)(view.getScale() * (double)androidY);
    }

    public static int getSwingDimension(@NotNull SceneView view, int androidDimension) {
        return (int)(view.getScale() * (double)androidDimension);
    }

    public static int getSwingDimension(@NotNull DesignSurface surface, int androidDimension) {
        return (int)(surface.getScale() * (double)androidDimension);
    }

    public static int dpToPx(@NotNull SceneView view, int androidDp) {
        Configuration configuration = view.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round((float)androidDp * ((float)dpiValue / 160.0f));
    }

    public static int dpToPx(@NotNull NlModel model, float androidDp) {
        Configuration configuration = model.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round(androidDp * ((float)dpiValue / 160.0f));
    }

    public static int pxToDp(@NotNull NlModel model, int androidPx) {
        Configuration configuration = model.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round((float)androidPx * (160.0f / (float)dpiValue));
    }

    public static int dpToPx(@NotNull SceneView view, float androidDp) {
        return Coordinates.dpToPx(view.getModel(), androidDp);
    }

    public static int pxToDp(@NotNull SceneView view, int androidPx) {
        return Coordinates.pxToDp(view.getModel(), androidPx);
    }

    public static int getSwingXDip(@NotNull SceneView view, int androidDpX) {
        return Coordinates.getSwingX(view, Coordinates.dpToPx(view, androidDpX));
    }

    public static int getSwingYDip(@NotNull SceneView view, int androidDpY) {
        return Coordinates.getSwingY(view, Coordinates.dpToPx(view, androidDpY));
    }

    public static int getSwingDimensionDip(@NotNull SceneView view, int androidDpDimension) {
        return Coordinates.getSwingDimension(view, Coordinates.dpToPx(view, androidDpDimension));
    }

    public static Rectangle getSwingRectDip(@NotNull SceneContext context, @NotNull Rectangle rect) {
        return new Rectangle(context.getSwingX(rect.x), context.getSwingY(rect.y), context.getSwingDimension(rect.width), context.getSwingDimension(rect.height));
    }

    public static Rectangle getSwingRectDip(@NotNull SceneView view, @NotNull Rectangle rect) {
        return new Rectangle(Coordinates.getSwingX(view, rect.x), Coordinates.getSwingY(view, rect.y), Coordinates.getSwingDimension(view, rect.width), Coordinates.getSwingDimension(view, rect.height));
    }

    public static int getAndroidX(@NotNull SceneView view, int swingX) {
        return (int)((double)(swingX - view.getX() - view.getContentTranslationX()) / view.getScale());
    }

    public static int getAndroidXDip(@NotNull SceneView view, int swingX) {
        return Coordinates.pxToDp(view, Coordinates.getAndroidX(view, swingX));
    }

    public static int getAndroidY(@NotNull SceneView view, int swingY) {
        return (int)((double)(swingY - view.getY() - view.getContentTranslationY()) / view.getScale());
    }

    public static int getAndroidYDip(@NotNull SceneView view, int swingY) {
        return Coordinates.pxToDp(view, Coordinates.getAndroidY(view, swingY));
    }

    @NotNull
    public static Point getAndroidCoordinate(@NotNull SceneView view, @NotNull Point coord) {
        return new Point(Coordinates.getAndroidX(view, coord.x), Coordinates.getAndroidY(view, coord.y));
    }

    public static int getAndroidDimension(@NotNull SceneView view, int swingDimension) {
        return (int)((double)swingDimension / view.getScale());
    }

    public static int getAndroidDimension(@NotNull DesignSurface surface, int swingDimension) {
        return (int)((double)swingDimension / surface.getScale());
    }

    public static int getAndroidDimensionDip(@NotNull SceneView view, int swingDimension) {
        return Coordinates.pxToDp(view, Coordinates.getSwingDimension(view, swingDimension));
    }

    public static int getAndroidDimensionDip(@NotNull DesignSurface surface, int swingDimension) {
        return Coordinates.pxToDp(surface.getModel(), Coordinates.getAndroidDimension(surface, swingDimension));
    }

    @Deprecated
    @Nullable
    public static NlComponent findComponent(@NotNull SceneView view, int swingX, int swingY) {
        SceneComponent sceneComponent = view.getScene().findComponent(SceneContext.get(view), Coordinates.getAndroidXDip(view, swingX), Coordinates.getAndroidYDip(view, swingY));
        return sceneComponent != null ? sceneComponent.getNlComponent() : null;
    }

    public static void transformGraphics(@NotNull SceneView view, @NotNull Graphics2D gc) {
        gc.translate(view.getX(), view.getY());
        gc.scale(view.getScale(), view.getScale());
    }
}

