/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.handlers.relative.DependencyGraph;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponent
implements NlAttributesHolder {
    @Nullable
    private XmlModelComponentMixin myMixin;
    @Nullable
    public List<NlComponent> children;
    private NlComponent myParent;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private XmlTag myTag;
    @NotNull
    private String myTagName;
    @Nullable
    private TagSnapshot mySnapshot;
    final HashMap<Object, Object> myClientProperties = new HashMap();
    private final ListenerCollection<ChangeListener> myListeners = ListenerCollection.createWithDirectExecutor();
    private final ChangeEvent myChangeEvent = new ChangeEvent(this);
    private DependencyGraph myCachedDependencyGraph;
    @Nullable
    AttributesTransaction myCurrentTransaction;

    public NlComponent(@NotNull NlModel model, @NotNull XmlTag tag) {
        this.myModel = model;
        this.myTag = tag;
        this.myTagName = tag.getName();
    }

    public void setMixin(@NotNull XmlModelComponentMixin mixin) {
        assert (this.myMixin == null);
        this.myMixin = mixin;
    }

    @Nullable
    public XmlModelComponentMixin getMixin() {
        return this.myMixin;
    }

    @NotNull
    public XmlTag getTag() {
        return this.myTag;
    }

    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    public void setTag(@NotNull XmlTag tag) {
        this.myTag = tag;
        this.myTagName = tag.getName();
    }

    @Nullable
    public TagSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    public void setSnapshot(@Nullable TagSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public void addChild(@NotNull NlComponent component2) {
        this.addChild(component2, null);
    }

    public void addChild(@NotNull NlComponent component2, @Nullable NlComponent before) {
        int index;
        if (component2 == this) {
            throw new IllegalArgumentException();
        }
        if (this.children == null) {
            this.children = Lists.newArrayList();
        }
        int n = index = before != null ? this.children.indexOf(before) : -1;
        if (index != -1) {
            this.children.add(index, component2);
        } else {
            this.children.add(component2);
        }
        component2.setParent(this);
    }

    public void removeChild(@NotNull NlComponent component2) {
        if (component2 == this) {
            throw new IllegalArgumentException();
        }
        if (this.children != null) {
            this.children.remove(component2);
        }
        component2.setParent(null);
    }

    public void setChildren(@Nullable List<NlComponent> components) {
        this.children = components;
        if (components != null) {
            for (NlComponent component2 : components) {
                if (component2 == this) {
                    throw new IllegalArgumentException();
                }
                component2.setParent(this);
            }
        }
    }

    @NotNull
    public List<NlComponent> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Nullable
    public NlComponent getChild(int index) {
        return this.children != null && index >= 0 && index < this.children.size() ? this.children.get(index) : null;
    }

    @NotNull
    public Stream<NlComponent> flatten() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(NlComponent::flatten));
    }

    @NotNull
    public DependencyGraph getDependencyGraph() {
        if (this.myCachedDependencyGraph == null || this.myCachedDependencyGraph.isStale(this)) {
            this.myCachedDependencyGraph = new DependencyGraph(this);
        }
        return this.myCachedDependencyGraph;
    }

    @Nullable
    public NlComponent getNextSibling() {
        if (this.myParent == null) {
            return null;
        }
        for (int index = 0; index < this.myParent.getChildCount(); ++index) {
            if (this.myParent.getChild(index) != this) continue;
            return this.myParent.getChild(index + 1);
        }
        return null;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (this.myTag == tag) {
            return this;
        }
        for (NlComponent child : this.getChildren()) {
            NlComponent result = child.findViewByTag(tag);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void findViewsByTag(@NotNull XmlTag tag, @NotNull ImmutableList.Builder<NlComponent> builder) {
        if (this.children == null && this.myTag == tag) {
            builder.add((Object)this);
            return;
        }
        for (NlComponent child : this.getChildren()) {
            child.findViewsByTag(tag, builder);
        }
        if (this.myTag == tag) {
            builder.add((Object)this);
        }
    }

    @NotNull
    public ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.findViewsByTag(tag, (ImmutableList.Builder<NlComponent>)builder);
        return builder.build();
    }

    public boolean isRoot() {
        return !(this.myTag.getParent() instanceof XmlTag);
    }

    public NlComponent getRoot() {
        NlComponent component2;
        for (component2 = this; component2 != null && !component2.isRoot(); component2 = component2.getParent()) {
        }
        return component2;
    }

    @Nullable
    public String getId() {
        String id = this.myCurrentTransaction != null ? this.myCurrentTransaction.getAndroidAttribute("id") : this.getAndroidAttribute("id");
        return NlComponent.stripId(id);
    }

    @Nullable
    public static String stripId(@Nullable String id) {
        if (id != null) {
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return null;
    }

    public static Collection<String> getIds(@NotNull NlModel model) {
        AndroidFacet facet = model.getFacet();
        AppResourceRepository resources = AppResourceRepository.getOrCreateInstance(facet);
        ArrayList ids = resources.getItemsOfType(ResourceType.ID);
        Set<String> pendingIds = model.getPendingIds();
        if (!pendingIds.isEmpty()) {
            ArrayList all = Lists.newArrayListWithCapacity((int)(pendingIds.size() + ids.size()));
            all.addAll(ids);
            all.addAll(pendingIds);
            ids = all;
        }
        return ids;
    }

    @Nullable
    public NlComponent getParent() {
        return this.myParent;
    }

    private void setParent(@Nullable NlComponent parent) {
        this.myParent = parent;
    }

    @NotNull
    public String getTagName() {
        return this.myTagName;
    }

    public String toString() {
        if (this.getMixin() != null) {
            return this.getMixin().toString();
        }
        return String.format("<%s>", this.myTagName);
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String attribute, @Nullable String value) {
        String previous;
        if (!this.myTag.isValid()) {
            return;
        }
        String prefix = null;
        if (namespace != null && !"http://schemas.android.com/apk/res/android".equals(namespace)) {
            prefix = AndroidResourceUtil.ensureNamespaceImported((XmlFile)this.myTag.getContainingFile(), namespace, null);
        }
        if (Objects.equals(previous = this.getAttribute(namespace, attribute), value)) {
            return;
        }
        this.myTag.setAttribute(attribute, namespace, value);
        if (this.mySnapshot != null) {
            this.mySnapshot.setAttribute(attribute, namespace, prefix, value);
        }
    }

    @NotNull
    public AttributesTransaction startAttributeTransaction() {
        if (this.myCurrentTransaction == null) {
            this.myCurrentTransaction = new AttributesTransaction(this);
        }
        return this.myCurrentTransaction;
    }

    @Nullable
    public String getLiveAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (this.myCurrentTransaction != null) {
            return this.myCurrentTransaction.getAttribute(namespace, attribute);
        }
        return this.getAttribute(namespace, attribute);
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (this.mySnapshot != null) {
            return this.mySnapshot.getAttribute(attribute, namespace);
        }
        if (AndroidPsiUtils.isValid(this.myTag)) {
            return AndroidPsiUtils.getAttributeSafely(this.myTag, namespace, attribute);
        }
        return null;
    }

    @Nullable
    public String resolveAttribute(@NotNull String namespace, @NotNull String attribute) {
        String attributeValue = this.getAttribute(namespace, attribute);
        if (attributeValue != null) {
            return attributeValue;
        }
        String styleAttributeValue = this.getAttribute(null, "style");
        if (styleAttributeValue == null) {
            return null;
        }
        ResourceResolver resources = this.myModel.getConfiguration().getResourceResolver();
        if (resources == null) {
            return null;
        }
        ResourceValue tmpResourceValue = new ResourceValue(ResourceUrl.create(null, (ResourceType)ResourceType.STYLE, (String)this.myTagName), styleAttributeValue);
        ResourceValue styleResourceValue = resources.resolveResValue(tmpResourceValue);
        if (!(styleResourceValue instanceof StyleResourceValue)) {
            return null;
        }
        ResourceValue itemResourceValue = resources.findItemInStyle((StyleResourceValue)styleResourceValue, attribute, true);
        if (itemResourceValue == null) {
            return null;
        }
        return itemResourceValue.getValue();
    }

    @NotNull
    public List<AttributeSnapshot> getAttributes() {
        if (this.mySnapshot != null) {
            return this.mySnapshot.attributes;
        }
        if (this.myTag.isValid()) {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (List)application.runReadAction(() -> AttributeSnapshot.createAttributesForTag(this.myTag));
            }
            return AttributeSnapshot.createAttributesForTag(this.myTag);
        }
        return Collections.emptyList();
    }

    public String ensureNamespace(@NotNull String prefix, @NotNull String namespace) {
        return AndroidResourceUtil.ensureNamespaceImported((XmlFile)this.myTag.getContainingFile(), namespace, prefix);
    }

    public boolean isShowing() {
        return this.mySnapshot != null;
    }

    @Nullable
    public static String extractId(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int index = str.lastIndexOf("@id/");
        if (index != -1) {
            return str.substring(index + 4);
        }
        index = str.lastIndexOf("@+id/");
        if (index != -1) {
            return str.substring(index + 5);
        }
        return null;
    }

    public final void putClientProperty(Object key, Object value) {
        this.myClientProperties.put(key, value);
    }

    public final Object getClientProperty(Object key) {
        return this.myClientProperties.get(key);
    }

    public final Object removeClientProperty(Object key) {
        return this.myClientProperties.remove(key);
    }

    public void addLiveChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    public void removeLiveChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public void fireLiveChangeEvent() {
        this.myListeners.forEach(listener -> listener.stateChanged(this.myChangeEvent));
    }

    @NotNull
    public String assignId() {
        return this.assignId(this.getTagName());
    }

    @NotNull
    public String assignId(@NotNull String baseName) {
        return this.assignId(baseName, NlComponent.getIds(this.getModel()));
    }

    @NotNull
    public String assignId(@NotNull Collection<String> ids) {
        return this.assignId(this.getTagName(), ids);
    }

    @NotNull
    public String assignId(@NotNull String baseName, @NotNull Collection<String> ids) {
        String idValue = StringUtil.decapitalize((String)baseName.substring(baseName.lastIndexOf(46) + 1));
        Module module = this.getModel().getModule();
        Project project = module.getProject();
        String nextIdValue = idValue = ResourceHelper.prependResourcePrefix(module, idValue, ResourceFolderType.LAYOUT);
        int index = 0;
        NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        while (ids.contains(nextIdValue) || validator != null && validator.isKeyword(nextIdValue, project)) {
            if (!(++index != 1 || validator != null && validator.isKeyword(nextIdValue, project))) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + index;
        }
        String newId = idValue + (index == 0 ? "" : Integer.valueOf(index));
        NlAttributesHolder attributes = this.myCurrentTransaction == null ? this : this.myCurrentTransaction;
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "id", "@+id/" + newId);
        this.getModel().getPendingIds().add(newId);
        return newId;
    }

    public boolean isSelected() {
        return this.getModel().getSelectionModel().isSelected(this);
    }

    public static abstract class XmlModelComponentMixin {
        private final NlComponent myComponent;

        public XmlModelComponentMixin(@NotNull NlComponent component2) {
            this.myComponent = component2;
        }

        @NotNull
        protected NlComponent getComponent() {
            return this.myComponent;
        }

        public String toString() {
            return String.format("<%s>", this.myComponent.getTagName());
        }
    }
}

