/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.editor.SetZoomActionGroups;
import com.android.tools.idea.common.editor.ToolbarActionGroups;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.naveditor.editor.NavToolbarActionGroups;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.uibuilder.adaptiveicon.AdaptiveIconActionGroups;
import com.android.tools.idea.uibuilder.editor.DefaultNlToolbarActionGroups;
import com.android.tools.idea.uibuilder.statelist.StateListActionGroups;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.Locale;
import org.jetbrains.android.dom.FileDescriptionUtils;
import org.jetbrains.android.dom.drawable.fileDescriptions.AdaptiveIconDomFileDescription;
import org.jetbrains.android.dom.font.FontFamilyDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.menu.MenuDomFileDescription;
import org.jetbrains.android.dom.navigation.NavigationDomFileDescription;
import org.jetbrains.annotations.NotNull;

public enum NlLayoutType {
    ADAPTIVE_ICON(false){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            return AdaptiveIconDomFileDescription.isAdaptiveIcon(file);
        }

        @Override
        @NotNull
        public ToolbarActionGroups getToolbarActionGroups(@NotNull DesignSurface surface) {
            return new AdaptiveIconActionGroups(surface);
        }
    }
    ,
    FONT(false){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            return FontFamilyDomFileDescription.isFontFamilyFile(file);
        }
    }
    ,
    LAYOUT(true){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            return LayoutDomFileDescription.isLayoutFile(file);
        }
    }
    ,
    MENU(true){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            return MenuDomFileDescription.isMenuFile(file);
        }

        @Override
        @NotNull
        public ToolbarActionGroups getToolbarActionGroups(@NotNull DesignSurface surface) {
            return new SetZoomActionGroups(surface);
        }
    }
    ,
    NAV(true){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            return NavSceneManager.enableNavigationEditor() && NavigationDomFileDescription.isNavFile(file);
        }

        @Override
        @NotNull
        public ToolbarActionGroups getToolbarActionGroups(@NotNull DesignSurface surface) {
            return new NavToolbarActionGroups(surface);
        }
    }
    ,
    PREFERENCE_SCREEN(true){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            return FileDescriptionUtils.isResourceOfType(file, ResourceFolderType.XML, Collections.singleton("PreferenceScreen"));
        }
    }
    ,
    STATE_LIST(true){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            return FileDescriptionUtils.isResourceOfType(file, ResourceFolderType.DRAWABLE, Collections.singleton("selector"));
        }

        @Override
        @NotNull
        public ToolbarActionGroups getToolbarActionGroups(@NotNull DesignSurface surface) {
            return new StateListActionGroups(surface);
        }
    }
    ,
    UNKNOWN(false){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            return false;
        }

        @Override
        @NotNull
        public String getPaletteFileName() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ToolbarActionGroups getToolbarActionGroups(@NotNull DesignSurface surface) {
            return new ToolbarActionGroups(surface);
        }
    }
    ,
    VECTOR(false){

        @Override
        public boolean isResourceTypeOf(@NotNull XmlFile file) {
            return FileDescriptionUtils.isResourceOfType(file, ResourceFolderType.DRAWABLE, Collections.singleton("vector"));
        }

        @Override
        @NotNull
        public ToolbarActionGroups getToolbarActionGroups(@NotNull DesignSurface surface) {
            return new SetZoomActionGroups(surface);
        }
    };

    private final boolean mySupportedByDesigner;

    private NlLayoutType(boolean supportedByDesigner) {
        this.mySupportedByDesigner = supportedByDesigner;
    }

    public abstract boolean isResourceTypeOf(@NotNull XmlFile var1);

    public boolean isLayout() {
        return this == LAYOUT;
    }

    public static boolean supports(@NotNull XmlFile file) {
        return NlLayoutType.typeOf(file).isSupportedByDesigner();
    }

    @NotNull
    public static NlLayoutType typeOf(@NotNull XmlFile file) {
        for (NlLayoutType type : NlLayoutType.values()) {
            if (!type.isResourceTypeOf(file)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public boolean isSupportedByDesigner() {
        return this.mySupportedByDesigner;
    }

    @NotNull
    public String getPaletteFileName() {
        return this.toString().toLowerCase(Locale.ROOT) + "_palette.xml";
    }

    @NotNull
    public ToolbarActionGroups getToolbarActionGroups(@NotNull DesignSurface surface) {
        return new DefaultNlToolbarActionGroups((NlDesignSurface)surface);
    }
}

