/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.ZoomType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.RefreshRenderAction;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.NlComponentUtil;
import com.android.tools.idea.uibuilder.model.NlModelHelper;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlModel
implements Disposable,
ResourceNotificationManager.ResourceChangeListener,
ModificationTracker {
    private static final boolean CHECK_MODEL_INTEGRITY = false;
    private final Set<String> myPendingIds = Sets.newHashSet();
    @NotNull
    private final DesignSurface mySurface;
    @NotNull
    private final AndroidFacet myFacet;
    private final XmlFile myFile;
    private final ConfigurationListener myConfigurationListener = new ConfigurationListener(){

        @Override
        public boolean changed(int flags) {
            if ((flags & 6) != 0 && !NlModel.this.mySurface.isLayoutDisabled()) {
                NlModel.this.mySurface.zoom(ZoomType.FIT_INTO);
            }
            return true;
        }
    };
    private final Configuration myConfiguration;
    private final ListenerCollection<ModelListener> myListeners = ListenerCollection.createWithDirectExecutor();
    private NlComponent myRootComponent;
    private LintAnnotationsModel myLintAnnotationsModel;
    private final long myId;
    private final Set<Object> myActivations = Collections.newSetFromMap(new WeakHashMap());
    private final ModelVersion myModelVersion = new ModelVersion();
    private final NlLayoutType myType;
    private long myConfigurationModificationCount;
    private ChangeType myModificationTrigger;

    @NotNull
    public static NlModel create(@NotNull DesignSurface surface, @Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull XmlFile file) {
        return new NlModel(surface, parent, facet, file);
    }

    @VisibleForTesting
    protected NlModel(@NotNull DesignSurface surface, @Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull XmlFile file) {
        this.mySurface = surface;
        this.myFacet = facet;
        this.myFile = file;
        this.myConfiguration = ConfigurationManager.getOrCreateInstance(facet).getConfiguration(this.myFile.getVirtualFile());
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
        this.myId = System.nanoTime() ^ (long)file.getName().hashCode();
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        this.myType = NlLayoutType.typeOf(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(@NotNull Object source) {
        boolean wasActive;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            wasActive = !this.myActivations.isEmpty();
            this.myActivations.add(source);
        }
        if (!wasActive) {
            this.myConfiguration.addListener(this.myConfigurationListener);
            if (this.myConfiguration.getModificationCount() != this.myConfigurationModificationCount) {
                this.updateTheme();
            }
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getProject());
            manager.addListener(this, this.myFacet, (PsiFile)this.myFile, this.myConfiguration);
            this.myListeners.forEach(listener -> listener.modelActivated(this));
        }
    }

    public void updateTheme() {
        ResourceResolver resolver;
        ResourceUrl themeUrl;
        String theme = this.myConfiguration.getTheme();
        ResourceUrl resourceUrl = themeUrl = theme != null ? ResourceUrl.parse((String)this.myConfiguration.getTheme()) : null;
        if (themeUrl != null && themeUrl.type == ResourceType.STYLE && ((resolver = this.myConfiguration.getResourceResolver()) == null || resolver.getTheme(themeUrl.name, themeUrl.framework) == null)) {
            this.myConfiguration.setTheme(this.myConfiguration.getConfigurationManager().computePreferredTheme(this.myConfiguration));
        }
    }

    private void deactivate() {
        this.myListeners.forEach(listener -> listener.modelDeactivated(this));
        ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.myFile.getProject());
        manager.removeListener(this, this.myFacet, (PsiFile)this.myFile, this.myConfiguration);
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
        this.myConfiguration.removeListener(this.myConfigurationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(@NotNull Object source) {
        boolean shouldDeactivate;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            boolean removed = this.myActivations.remove(source);
            shouldDeactivate = removed && this.myActivations.isEmpty();
        }
        if (shouldDeactivate) {
            this.deactivate();
        }
    }

    @NotNull
    public XmlFile getFile() {
        return this.myFile;
    }

    @NotNull
    public NlLayoutType getType() {
        return this.myType;
    }

    @NotNull
    public DesignSurface getSurface() {
        return this.mySurface;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.mySurface.getSelectionModel();
    }

    @Nullable
    public LintAnnotationsModel getLintAnnotationsModel() {
        return this.myLintAnnotationsModel;
    }

    public void setLintAnnotationsModel(@Nullable LintAnnotationsModel model) {
        this.myLintAnnotationsModel = model;
    }

    @NotNull
    Set<String> getPendingIds() {
        return this.myPendingIds;
    }

    public void syncWithPsi(@NotNull XmlTag newRoot, @NotNull List<TagSnapshotTreeNode> roots) {
        new ModelUpdater(this).update(newRoot, roots);
    }

    public void checkStructure() {
    }

    private void checkUnique(NlComponent component2, Set<NlComponent> unique) {
    }

    private void checkUnique(XmlTag tag, Set<XmlTag> unique) {
    }

    private void checkStructure(NlComponent component2) {
    }

    public void addListener(@NotNull ModelListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(@Nullable ModelListener listener) {
        this.myListeners.remove(listener);
    }

    public void notifyListenersModelUpdateComplete() {
        this.myListeners.forEach(listener -> listener.modelDerivedDataChanged(this));
    }

    public void notifyListenersRenderComplete() {
        this.myListeners.forEach(listener -> listener.modelRendered(this));
    }

    public void notifyListenersModelLayoutComplete(boolean animate) {
        this.myListeners.forEach(listener -> listener.modelChangedOnLayout(this, animate));
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    public Module getModule() {
        return this.myFacet.getModule();
    }

    @NotNull
    public Project getProject() {
        return this.getModule().getProject();
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @NotNull
    public ImmutableList<NlComponent> getComponents() {
        return this.myRootComponent != null ? ImmutableList.of((Object)this.myRootComponent) : ImmutableList.of();
    }

    @NotNull
    public Stream<NlComponent> flattenComponents() {
        return this.myRootComponent != null ? Stream.of(this.myRootComponent).flatMap(NlComponent::flatten) : Stream.empty();
    }

    public void notifyLiveUpdate(boolean animate) {
        this.myListeners.forEach(listener -> listener.modelLiveUpdate(this, animate));
    }

    @NotNull
    public ImmutableList<NlComponent> findByOffset(int offset) {
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.myFile, (int)offset, XmlTag.class, (boolean)false);
        return tag != null ? this.findViewsByTag(tag) : ImmutableList.of();
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        return this.myRootComponent != null ? this.myRootComponent.findViewByTag(tag) : null;
    }

    @Nullable
    public NlComponent find(@NotNull String id) {
        return this.flattenComponents().filter(c -> id.equals(c.getId())).findFirst().orElse(null);
    }

    @NotNull
    private ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (this.myRootComponent == null) {
            return ImmutableList.of();
        }
        return this.myRootComponent.findViewsByTag(tag);
    }

    @Nullable
    public NlComponent findViewByPsi(@Nullable PsiElement element) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        while (element != null) {
            if (element instanceof XmlTag) {
                return this.findViewByTag((XmlTag)element);
            }
            element = element.getParent();
        }
        return null;
    }

    public void delete(final Collection<NlComponent> components) {
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(this.myFacet.getModule().getProject(), "Delete Component", new PsiFile[]{this.myFile}){

            protected void run(@NotNull Result<Void> result) throws Throwable {
                NlModel.this.handleDeletion(components);
            }
        };
        action.execute();
        ArrayList remaining = Lists.newArrayList(this.getSelectionModel().getSelection());
        remaining.removeAll(components);
        this.getSelectionModel().setSelection(remaining);
        this.notifyModified(ChangeType.DELETE);
    }

    private void handleDeletion(@NotNull Collection<NlComponent> components) {
        Multimap<NlComponent, NlComponent> siblingLists = NlComponentUtil.groupSiblings(components);
        for (NlComponent parent : siblingLists.keySet()) {
            Collection children;
            if (parent == null || NlModelHelper.INSTANCE.handleDeletion(parent, children = siblingLists.get((Object)parent))) continue;
            for (NlComponent component2 : children) {
                NlComponent p = component2.getParent();
                if (p != null) {
                    p.removeChild(component2);
                }
                component2.getTag().delete();
            }
        }
    }

    public NlComponent createComponent(@NotNull XmlTag tag, @Nullable NlComponent parent, @Nullable NlComponent before) {
        if (parent != null) {
            XmlTag parentTag = parent.getTag();
            tag = before != null ? (XmlTag)parentTag.addBefore((PsiElement)tag, (PsiElement)before.getTag()) : parentTag.addSubTag(tag, false);
        }
        NlComponent child = this.createComponent(tag);
        if (parent != null) {
            parent.addChild(child, before);
        }
        return child;
    }

    public NlComponent createComponent(@NotNull XmlTag tag) {
        return this.mySurface.createComponent(tag);
    }

    @NotNull
    public Transferable getSelectionAsTransferable() {
        return this.getSelectionModel().getTransferable(this.myId);
    }

    public boolean canAddComponents(@Nullable List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before) {
        if (before != null && before.getParent() != receiver) {
            return false;
        }
        if (toAdd == null || toAdd.isEmpty()) {
            return false;
        }
        if (!NlModelHelperKt.canAddComponents(this, receiver, toAdd)) {
            return false;
        }
        for (NlComponent component2 : toAdd) {
            for (NlComponent same = receiver; same != null; same = same.getParent()) {
                if (same != component2) continue;
                return false;
            }
        }
        return true;
    }

    public void addComponents(@Nullable List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (!this.canAddComponents(toAdd, receiver, before)) {
            return;
        }
        if (!NlModelHelperKt.addDependencies(this, toAdd, insertType)) {
            return;
        }
        assert (toAdd != null);
        NlWriteCommandAction.run(toAdd, insertType.getDragType().getDescription(), () -> this.handleAddition(toAdd, receiver, before, insertType));
        this.notifyModified(ChangeType.ADD_COMPONENTS);
    }

    public void addTags(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        NlWriteCommandAction.run(added, insertType.getDragType().getDescription(), () -> {
            for (NlComponent component2 : added) {
                NlComponent parent = component2.getParent();
                if (parent != null) {
                    parent.removeChild(component2);
                }
                receiver.addChild(component2, before);
                if (receiver.getTag() != component2.getTag()) {
                    XmlTag prev = component2.getTag();
                    this.transferNamespaces(prev);
                    if (before != null) {
                        component2.setTag((XmlTag)receiver.getTag().addBefore((PsiElement)component2.getTag(), (PsiElement)before.getTag()));
                    } else {
                        component2.setTag(receiver.getTag().addSubTag(component2.getTag(), false));
                    }
                    if (insertType.isMove()) {
                        prev.delete();
                    }
                }
                NlModel.removeNamespaceAttributes(component2);
            }
        });
        this.notifyModified(ChangeType.ADD_COMPONENTS);
    }

    private void handleAddition(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        NlModelHelperKt.handleAddition(this, added, receiver, insertType, this.mySurface);
        for (NlComponent component2 : added) {
            NlComponent parent = component2.getParent();
            if (parent != null) {
                parent.removeChild(component2);
            }
            receiver.addChild(component2, before);
            if (receiver.getTag() != component2.getTag()) {
                XmlTag prev = component2.getTag();
                this.transferNamespaces(prev);
                if (before != null) {
                    component2.setTag((XmlTag)receiver.getTag().addBefore((PsiElement)component2.getTag(), (PsiElement)before.getTag()));
                } else {
                    component2.setTag(receiver.getTag().addSubTag(component2.getTag(), false));
                }
                if (insertType.isMove()) {
                    prev.delete();
                }
            }
            NlModel.removeNamespaceAttributes(component2);
        }
    }

    private void transferNamespaces(@NotNull XmlTag tag) {
        XmlDocument xmlDocument = this.myFile.getDocument();
        assert (xmlDocument != null);
        XmlTag rootTag = xmlDocument.getRootTag();
        assert (rootTag != null);
        Map prefixToNamespace = rootTag.getLocalNamespaceDeclarations();
        HashMap namespaceToPrefix = Maps.newHashMap();
        for (Map.Entry entry : prefixToNamespace.entrySet()) {
            namespaceToPrefix.put(entry.getValue(), entry.getKey());
        }
        HashMap oldPrefixToPrefix = Maps.newHashMap();
        for (Map.Entry entry : tag.getLocalNamespaceDeclarations().entrySet()) {
            String namespace = (String)entry.getValue();
            String prefix = (String)entry.getKey();
            String currentPrefix = (String)namespaceToPrefix.get(namespace);
            if (currentPrefix == null) {
                String newPrefix = AndroidResourceUtil.ensureNamespaceImported(this.myFile, namespace, prefix);
                if (prefix.equals(newPrefix)) continue;
                oldPrefixToPrefix.put(prefix, newPrefix);
                namespaceToPrefix.put(namespace, newPrefix);
                continue;
            }
            if (prefix.equals(currentPrefix)) continue;
            oldPrefixToPrefix.put(prefix, currentPrefix);
        }
        if (!oldPrefixToPrefix.isEmpty()) {
            NlModel.updatePrefixes(tag, oldPrefixToPrefix);
        }
    }

    private static void updatePrefixes(@NotNull XmlTag tag, @NotNull Map<String, String> oldPrefixToPrefix) {
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String newPrefix;
            String prefix = xmlAttribute.getNamespacePrefix();
            if (prefix.isEmpty()) continue;
            if (prefix.equals("xmlns")) {
                newPrefix = oldPrefixToPrefix.get(xmlAttribute.getLocalName());
                if (newPrefix == null) continue;
                xmlAttribute.setName("xmlns:" + newPrefix);
                continue;
            }
            newPrefix = oldPrefixToPrefix.get(prefix);
            if (newPrefix == null) continue;
            xmlAttribute.setName(newPrefix + ':' + xmlAttribute.getLocalName());
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            NlModel.updatePrefixes((XmlTag)xmlAttribute, oldPrefixToPrefix);
        }
    }

    private static void removeNamespaceAttributes(NlComponent component2) {
        for (XmlAttribute attribute : component2.getTag().getAttributes()) {
            if (!attribute.getName().startsWith("xmlns:")) continue;
            attribute.delete();
        }
    }

    @NotNull
    public InsertType determineInsertType(@NotNull DragType dragType, @Nullable DnDTransferItem item, boolean asPreview) {
        if (item != null && item.isFromPalette()) {
            return asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
        }
        switch (dragType) {
            case CREATE: {
                return asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
            }
            case MOVE: {
                return item != null && this.myId != item.getModelId() ? InsertType.COPY : InsertType.MOVE_INTO;
            }
            case COPY: {
                return InsertType.COPY;
            }
        }
        return InsertType.PASTE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean shouldDeactivate;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            shouldDeactivate = !this.myActivations.isEmpty();
            this.myActivations.clear();
        }
        if (shouldDeactivate) {
            this.deactivate();
        }
        this.myListeners.clear();
    }

    public String toString() {
        return NlModel.class.getSimpleName() + " for " + this.myFile;
    }

    @Override
    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reason) {
        for (ResourceNotificationManager.Reason r : reason) {
            switch (r) {
                case RESOURCE_EDIT: {
                    this.notifyModified(ChangeType.RESOURCE_EDIT);
                    break;
                }
                case EDIT: {
                    this.notifyModified(ChangeType.EDIT);
                    break;
                }
                case IMAGE_RESOURCE_CHANGED: {
                    RefreshRenderAction.clearCache(this.mySurface);
                    break;
                }
                case GRADLE_SYNC: 
                case PROJECT_BUILD: 
                case VARIANT_CHANGED: 
                case SDK_CHANGED: {
                    this.notifyModified(ChangeType.BUILD);
                    break;
                }
                case CONFIGURATION_CHANGED: {
                    this.notifyModified(ChangeType.CONFIGURATION_CHANGE);
                }
            }
        }
    }

    public long getModificationCount() {
        return this.myModelVersion.getVersion();
    }

    public long getConfigurationModificationCount() {
        return this.myConfigurationModificationCount;
    }

    public void notifyModified(ChangeType reason) {
        this.myModelVersion.increase(reason);
        this.updateTheme();
        this.myModificationTrigger = reason;
        this.myListeners.forEach(listener -> listener.modelChanged(this));
    }

    public ChangeType getLastChangeType() {
        return this.myModificationTrigger;
    }

    public void resetLastChange() {
        this.myModificationTrigger = null;
    }

    private /* synthetic */ void lambda$checkStructure$2() {
        Set unique = Sets.newIdentityHashSet();
        Set uniqueTags = Sets.newIdentityHashSet();
        this.checkUnique(this.myFile.getRootTag(), uniqueTags);
        uniqueTags.clear();
        if (this.myRootComponent != null) {
            this.checkUnique(this.myRootComponent.getTag(), uniqueTags);
            this.checkUnique(this.myRootComponent, unique);
            this.checkStructure(this.myRootComponent);
        }
    }

    static class ModelVersion {
        private final AtomicLong myVersion = new AtomicLong();
        ChangeType mLastReason;

        ModelVersion() {
        }

        public void increase(ChangeType reason) {
            this.myVersion.incrementAndGet();
            this.mLastReason = reason;
        }

        public long getVersion() {
            return this.myVersion.get();
        }
    }

    public static enum ChangeType {
        RESOURCE_EDIT,
        EDIT,
        RESOURCE_CHANGED,
        ADD_COMPONENTS,
        DELETE,
        DND_COMMIT,
        DND_END,
        DROP,
        RESIZE_END,
        RESIZE_COMMIT,
        UPDATE_HIERARCHY,
        BUILD,
        CONFIGURATION_CHANGE;

    }

    private static class ModelUpdater {
        private final NlModel myModel;
        private final Map<XmlTag, NlComponent> myTagToComponentMap = Maps.newIdentityHashMap();
        private final Map<NlComponent, XmlTag> myComponentToTagMap = Maps.newIdentityHashMap();
        protected final Map<TagSnapshot, NlComponent> mySnapshotToComponent = Maps.newIdentityHashMap();
        private final Map<XmlTag, TagSnapshot> myTagToSnapshot = Maps.newHashMap();

        public ModelUpdater(@NotNull NlModel model) {
            this.myModel = model;
        }

        private void recordComponentMapping(@NotNull XmlTag tag, @NotNull NlComponent component2) {
            XmlTag prevTag = this.myComponentToTagMap.get(component2);
            if (prevTag != null) {
                this.myTagToComponentMap.remove(prevTag);
            }
            this.myComponentToTagMap.put(component2, tag);
            this.myTagToComponentMap.put(tag, component2);
        }

        @VisibleForTesting
        public void update(@Nullable XmlTag newRoot, @NotNull List<TagSnapshotTreeNode> roots) {
            if (newRoot == null) {
                this.myModel.myRootComponent = null;
                return;
            }
            boolean isValidRoot = (Boolean)ApplicationManager.getApplication().runReadAction(() -> ((XmlTag)newRoot).isValid());
            if (!isValidRoot) {
                this.myModel.myRootComponent = null;
                return;
            }
            for (TagSnapshotTreeNode root : roots) {
                ModelUpdater.gatherTagsAndSnapshots(root, this.myTagToSnapshot);
            }
            NlComponent rootComponent = (NlComponent)ApplicationManager.getApplication().runReadAction(() -> {
                this.mapOldToNew(newRoot);
                for (Map.Entry<XmlTag, NlComponent> entry : this.myTagToComponentMap.entrySet()) {
                    XmlTag tag = entry.getKey();
                    NlComponent component2 = entry.getValue();
                    if (component2.getTagName().equals(tag.getName())) continue;
                    this.myTagToComponentMap.clear();
                    this.myComponentToTagMap.clear();
                    break;
                }
                return this.createTree(newRoot);
            });
            this.myModel.myRootComponent = rootComponent;
            for (NlComponent component2 : this.myTagToComponentMap.values()) {
                component2.setSnapshot(null);
            }
            for (TagSnapshotTreeNode root : roots) {
                this.updateHierarchy(root);
            }
        }

        private void mapOldToNew(@NotNull XmlTag newRootTag) {
            XmlTag oldTag;
            TagSnapshot snapshot;
            NlComponent component2;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            for (NlComponent component3 : this.myModel.getComponents()) {
                this.gatherTagsAndSnapshots(component3);
            }
            ArrayList missing = Lists.newArrayList();
            Set remaining = Sets.newIdentityHashSet();
            remaining.addAll(this.myTagToComponentMap.keySet());
            ModelUpdater.checkMissing(newRootTag, remaining, missing);
            if (missing.isEmpty()) {
                return;
            }
            if (remaining.isEmpty()) {
                return;
            }
            HashMap oldIds = Maps.newHashMap();
            for (Map.Entry<TagSnapshot, NlComponent> entry : this.mySnapshotToComponent.entrySet()) {
                String id;
                TagSnapshot snapshot2 = entry.getKey();
                if (snapshot2 == null || (id = snapshot2.getAttribute("id", "http://schemas.android.com/apk/res/android")) == null) continue;
                oldIds.put(id, entry.getValue());
            }
            ListIterator missingIterator = missing.listIterator();
            while (missingIterator.hasNext()) {
                XmlTag tag = (XmlTag)missingIterator.next();
                String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
                if (id == null || (component2 = (NlComponent)oldIds.get(id)) == null) continue;
                this.recordComponentMapping(tag, component2);
                remaining.remove(component2.getTag());
                missingIterator.remove();
            }
            if (missing.isEmpty() || remaining.isEmpty()) {
                return;
            }
            ArrayListMultimap snapshotIds = ArrayListMultimap.create();
            for (XmlTag old : remaining) {
                NlComponent component4 = this.myTagToComponentMap.get(old);
                if (component4 == null || (snapshot = component4.getSnapshot()) == null) continue;
                snapshotIds.put((Object)snapshot.getSignature(), (Object)snapshot);
            }
            missingIterator = missing.listIterator();
            while (missingIterator.hasNext()) {
                TagSnapshot first;
                NlComponent component5;
                long signature;
                Collection snapshots;
                XmlTag tag = (XmlTag)missingIterator.next();
                TagSnapshot snapshot3 = this.myTagToSnapshot.get(tag);
                if (snapshot3 == null || (snapshots = snapshotIds.get((Object)(signature = snapshot3.getSignature()))).isEmpty() || (component5 = this.mySnapshotToComponent.get(first = (TagSnapshot)snapshots.iterator().next())) == null) continue;
                this.recordComponentMapping(tag, component5);
                remaining.remove(component5.getTag());
                snapshotIds.remove((Object)tag, (Object)first);
                missingIterator.remove();
            }
            if (missing.size() == 1 && remaining.size() == 1 && (component2 = this.myTagToComponentMap.get(oldTag = (XmlTag)remaining.iterator().next())) != null) {
                XmlTag newTag = (XmlTag)missing.get(0);
                snapshot = component2.getSnapshot();
                if (snapshot != null && snapshot.tagName.equals(newTag.getName())) {
                    this.recordComponentMapping(newTag, component2);
                }
            }
        }

        private static void checkMissing(XmlTag tag, Set<XmlTag> remaining, List<XmlTag> missing) {
            boolean found = remaining.remove(tag);
            if (!found) {
                missing.add(tag);
            }
            for (XmlTag child : tag.getSubTags()) {
                ModelUpdater.checkMissing(child, remaining, missing);
            }
        }

        private void gatherTagsAndSnapshots(@NotNull NlComponent component2) {
            XmlTag tag = component2.getTag();
            this.recordComponentMapping(tag, component2);
            this.mySnapshotToComponent.put(component2.getSnapshot(), component2);
            for (NlComponent child : component2.getChildren()) {
                this.gatherTagsAndSnapshots(child);
            }
        }

        private static void gatherTagsAndSnapshots(@NotNull TagSnapshotTreeNode node, @NotNull Map<XmlTag, TagSnapshot> map) {
            TagSnapshot snapshot = node.getTagSnapshot();
            if (snapshot != null) {
                map.put(snapshot.tag, snapshot);
            }
            for (TagSnapshotTreeNode child : node.getChildren()) {
                ModelUpdater.gatherTagsAndSnapshots(child, map);
            }
        }

        @NotNull
        private NlComponent createTree(@NotNull XmlTag tag) {
            XmlTag[] subTags;
            NlComponent component2 = this.myTagToComponentMap.get(tag);
            if (component2 == null) {
                component2 = this.myModel.createComponent(tag);
                this.recordComponentMapping(tag, component2);
            }
            if ((subTags = tag.getSubTags()).length > 0) {
                ArrayList<NlComponent> children = new ArrayList<NlComponent>(subTags.length);
                for (XmlTag subtag : subTags) {
                    NlComponent child = this.createTree(subtag);
                    children.add(child);
                }
                component2.setChildren(children);
            } else {
                component2.setChildren(null);
            }
            return component2;
        }

        private void updateHierarchy(@NotNull TagSnapshotTreeNode node) {
            TagSnapshot snapshot = node.getTagSnapshot();
            if (snapshot != null) {
                NlComponent component2 = this.mySnapshotToComponent.get(snapshot);
                if (component2 == null) {
                    component2 = this.myTagToComponentMap.get(snapshot.tag);
                }
                if (component2 != null) {
                    component2.setSnapshot(snapshot);
                    assert (snapshot.tag != null);
                    component2.setTag(snapshot.tag);
                }
            }
            for (TagSnapshotTreeNode child : node.getChildren()) {
                this.updateHierarchy(child);
            }
        }
    }

    public static interface TagSnapshotTreeNode {
        @Nullable
        public TagSnapshot getTagSnapshot();

        @NotNull
        public List<TagSnapshotTreeNode> getChildren();
    }
}

