/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import com.android.tools.idea.uibuilder.model.SelectionHandles;
import com.android.tools.idea.util.ListenerCollection;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModel {
    @NotNull
    private ImmutableList<NlComponent> mySelection = ImmutableList.of();
    private NlComponent myPrimary;
    private ListenerCollection<SelectionListener> myListeners = ListenerCollection.createWithDirectExecutor();
    private Map<NlComponent, SelectionHandles> myHandles;

    @NotNull
    public ImmutableList<NlComponent> getSelection() {
        return this.mySelection;
    }

    @Nullable
    public NlComponent getPrimary() {
        return this.myPrimary;
    }

    public void setSelection(@NotNull List<NlComponent> components) {
        this.setSelection((List<NlComponent>)ImmutableList.copyOf(components), components.isEmpty() ? null : components.iterator().next());
    }

    public void setSelection(@NotNull List<NlComponent> components, @Nullable NlComponent primary) {
        if (components.equals(this.mySelection)) {
            return;
        }
        this.myHandles = null;
        this.mySelection = ImmutableList.copyOf(components);
        this.myPrimary = primary;
        this.notifySelectionChanged();
    }

    public void clear() {
        if (this.mySelection.isEmpty()) {
            return;
        }
        this.myHandles = null;
        this.mySelection = ImmutableList.of();
        this.myPrimary = null;
        this.notifySelectionChanged();
    }

    public void toggle(@NotNull NlComponent component2) {
        NlComponent newPrimary;
        ImmutableList newSelection;
        int size = this.mySelection.size();
        if (size == 0) {
            newSelection = ImmutableList.of((Object)component2);
            newPrimary = component2;
        } else if (this.mySelection.contains((Object)component2)) {
            if (size == 1) {
                newSelection = ImmutableList.of();
                newPrimary = null;
            } else {
                newSelection = (ImmutableList)this.mySelection.stream().filter(selection -> !selection.equals(component2)).collect(ImmutableCollectors.toImmutableList());
                newPrimary = this.myPrimary == component2 ? null : this.myPrimary;
            }
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.mySelection);
            builder.add((Object)component2);
            newSelection = builder.build();
            newPrimary = this.myPrimary;
        }
        this.setSelection((List<NlComponent>)newSelection, newPrimary);
    }

    private void notifySelectionChanged() {
        this.myListeners.forEach(l -> l.selectionChanged(this, (List<NlComponent>)this.mySelection));
    }

    public void addListener(@NotNull SelectionListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(@Nullable SelectionListener listener) {
        this.myListeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.mySelection.isEmpty();
    }

    @Nullable
    public SelectionHandle findHandle(int x, int y, int maxDistance) {
        if (this.myHandles == null) {
            return null;
        }
        for (SelectionHandles handles : this.myHandles.values()) {
            SelectionHandle handle = handles.findHandle(x, y, maxDistance);
            if (handle == null) continue;
            return handle;
        }
        return null;
    }

    @NotNull
    public SelectionHandles getHandles(@NotNull NlComponent component2) {
        SelectionHandles handles;
        if (this.myHandles == null) {
            this.myHandles = Maps.newHashMap();
        }
        if ((handles = this.myHandles.get(component2)) == null) {
            handles = new SelectionHandles(component2);
            this.myHandles.put(component2, handles);
        }
        return handles;
    }

    public boolean isSelected(@NotNull NlComponent component2) {
        return this.mySelection.contains((Object)component2);
    }

    public Transferable getTransferable(long modelId) {
        ImmutableList components = (ImmutableList)this.mySelection.stream().map(component2 -> new DnDTransferComponent(component2.getTagName(), component2.getTag().getText(), NlComponentHelperKt.getW(component2), NlComponentHelperKt.getH(component2))).collect(ImmutableCollectors.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(modelId, (ImmutableList<DnDTransferComponent>)components));
    }
}

