/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.surface.DesignSurface;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class Display {
    private long mTime;
    private DisplayList myDisplayList = new DisplayList();
    private long myDisplayListVersion = 0L;
    double myScale = 0.0;

    public void reLayout() {
        this.myDisplayListVersion = 0L;
    }

    public void draw(@NotNull SceneContext sceneContext, @NotNull Graphics2D g, @NotNull Scene scene) {
        DesignSurface designSurface;
        this.mTime = System.currentTimeMillis();
        boolean needsRebuild = false;
        if (scene.getDisplayListVersion() > this.myDisplayListVersion) {
            needsRebuild = true;
        }
        if (sceneContext.getScale() != this.myScale) {
            this.myScale = sceneContext.getScale();
            needsRebuild = true;
        }
        needsRebuild |= this.myDisplayList.getCommands().isEmpty();
        if (needsRebuild |= scene.layout(this.mTime, sceneContext)) {
            this.myDisplayList.clear();
            scene.buildDisplayList(this.myDisplayList, this.mTime, sceneContext);
            this.myDisplayListVersion = scene.getDisplayListVersion();
        }
        this.draw(sceneContext, g, this.myDisplayList);
        if (needsRebuild && (designSurface = sceneContext.getSurface()) != null) {
            designSurface.repaint();
        }
    }

    public void draw(@NotNull SceneContext sceneContext, @NotNull Graphics2D g, @NotNull DisplayList list) {
        sceneContext.setTime(System.currentTimeMillis());
        list.paint(g, sceneContext);
    }
}

