/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.ComponentProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneComponent {
    public static final int ANIMATION_DURATION = 350;
    public HashMap<String, Object> myCache = new HashMap();
    public SceneDecorator myDecorator;
    private boolean myAllowsAutoconnect = true;
    private TargetProvider myTargetProvider;
    private ComponentProvider myComponentProvider;
    private final Scene myScene;
    private final NlComponent myNlComponent;
    private ArrayList<SceneComponent> myChildren = new ArrayList();
    private SceneComponent myParent = null;
    private boolean myIsToolLocked = false;
    private boolean myIsSelected = false;
    private boolean myDragging = false;
    private boolean myIsModelUpdateAuthorized = true;
    private AnimatedValue myAnimatedDrawX = new AnimatedValue();
    private AnimatedValue myAnimatedDrawY = new AnimatedValue();
    private AnimatedValue myAnimatedDrawWidth = new AnimatedValue();
    private AnimatedValue myAnimatedDrawHeight = new AnimatedValue();
    private DrawState myDrawState = DrawState.NORMAL;
    private ArrayList<Target> myTargets = new ArrayList();
    private int myCurrentLeft = 0;
    private int myCurrentTop = 0;
    private int myCurrentRight = 0;
    private int myCurrentBottom = 0;
    private boolean myShowBaseline = false;
    private final boolean myAllowsFixedPosition;
    private Notch.Provider myNotchProvider;

    public int getCenterX() {
        return this.myCurrentLeft + (this.myCurrentRight - this.myCurrentLeft) / 2;
    }

    public int getCenterY() {
        return this.myCurrentTop + (this.myCurrentBottom - this.myCurrentTop) / 2;
    }

    public SceneComponent(@NotNull Scene scene, @NotNull NlComponent component2) {
        this.myScene = scene;
        this.myNlComponent = component2;
        this.myScene.addComponent(this);
        SceneManager manager = scene.getSceneManager();
        this.myDecorator = manager.getSceneDecoratorFactory().get(component2);
        this.myAllowsAutoconnect = !this.myNlComponent.getTagName().equalsIgnoreCase("android.support.constraint.Guideline");
        this.myAllowsFixedPosition = !this.myNlComponent.getTagName().equalsIgnoreCase("android.support.constraint.Guideline");
        this.setSelected(component2.isSelected());
    }

    public String toString() {
        return this.getNlComponent().toString() + " [ " + this.myCurrentLeft + ", " + this.myCurrentTop + " - " + this.myCurrentRight + ", " + this.myCurrentBottom + "]";
    }

    @Nullable
    public SceneComponent getParent() {
        return this.myParent;
    }

    public void setParent(@NotNull SceneComponent parent) {
        this.myParent = parent;
    }

    public TargetProvider getTargetProvider() {
        return this.myTargetProvider;
    }

    public boolean allowsAutoConnect() {
        return this.myScene.isAutoconnectOn() && this.myAllowsAutoconnect;
    }

    public boolean useRtlAttributes() {
        return this.myScene.supportsRTL();
    }

    public int findTarget(Class aClass) {
        int count = this.myTargets.size();
        for (int i = 0; i < count; ++i) {
            if (!aClass.isInstance(this.myTargets.get(i))) continue;
            return i;
        }
        return -1;
    }

    public void removeTarget(int pos) {
        this.myTargets.remove(pos);
    }

    public boolean hasAncestor(SceneComponent candidate) {
        for (SceneComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != candidate) continue;
            return true;
        }
        return false;
    }

    public boolean allowsFixedPosition() {
        return this.myAllowsFixedPosition;
    }

    public boolean isSelected() {
        return this.myIsSelected;
    }

    public boolean canShowBaseline() {
        return this.myShowBaseline;
    }

    public void setShowBaseline(boolean value) {
        this.myShowBaseline = value;
    }

    public int getDrawX() {
        return this.myAnimatedDrawX.getValue(0L);
    }

    public int getDrawY() {
        return this.myAnimatedDrawY.getValue(0L);
    }

    public int getOffsetParentX() {
        if (this.myParent != null) {
            return this.getDrawX() - this.myParent.getDrawX();
        }
        return this.getDrawX();
    }

    public int getOffsetParentY() {
        if (this.myParent != null) {
            return this.getDrawY() - this.myParent.getDrawY();
        }
        return this.getDrawY();
    }

    public int getDrawWidth() {
        return this.myAnimatedDrawWidth.getValue(0L);
    }

    public int getDrawHeight() {
        return this.myAnimatedDrawHeight.getValue(0L);
    }

    public int getDrawX(long time2) {
        return this.myAnimatedDrawX.getValue(time2);
    }

    public int getDrawY(long time2) {
        return this.myAnimatedDrawY.getValue(time2);
    }

    public int getDrawWidth(long time2) {
        return this.myAnimatedDrawWidth.getValue(time2);
    }

    public int getDrawHeight(long time2) {
        return this.myAnimatedDrawHeight.getValue(time2);
    }

    public void setPosition(int dx, int dy) {
        this.setPosition(dx, dy, false);
    }

    public void setPosition(int dx, int dy, boolean isFromModel) {
        if (!isFromModel || this.myIsModelUpdateAuthorized) {
            this.myAnimatedDrawX.setValue(dx);
            this.myAnimatedDrawY.setValue(dy);
            if (isFromModel) {
                NlComponentHelperKt.setX(this.myNlComponent, Coordinates.dpToPx(this.myNlComponent.getModel(), (float)dx));
                NlComponentHelperKt.setY(this.myNlComponent, Coordinates.dpToPx(this.myNlComponent.getModel(), (float)dy));
            } else {
                this.myScene.needsRebuildList();
            }
        }
    }

    public void setPositionTarget(int dx, int dy, long time2, boolean isFromModel) {
        if (!isFromModel || this.myIsModelUpdateAuthorized) {
            this.myAnimatedDrawX.setTarget(dx, time2);
            this.myAnimatedDrawY.setTarget(dy, time2);
            if (isFromModel) {
                NlComponentHelperKt.setX(this.myNlComponent, Coordinates.dpToPx(this.myNlComponent.getModel(), (float)dx));
                NlComponentHelperKt.setY(this.myNlComponent, Coordinates.dpToPx(this.myNlComponent.getModel(), (float)dy));
            } else {
                this.myScene.needsRebuildList();
            }
        }
    }

    public void setSize(int width, int height, boolean isFromModel) {
        if (!isFromModel || this.myIsModelUpdateAuthorized) {
            this.myAnimatedDrawWidth.setValue(width);
            this.myAnimatedDrawHeight.setValue(height);
            if (isFromModel && NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
                NlComponentHelperKt.setW(this.myNlComponent, Coordinates.dpToPx(this.myNlComponent.getModel(), (float)width));
                NlComponentHelperKt.setH(this.myNlComponent, Coordinates.dpToPx(this.myNlComponent.getModel(), (float)height));
            } else {
                this.myScene.needsRebuildList();
            }
        }
    }

    public void setSizeTarget(int width, int height, long time2, boolean isFromModel) {
        if (!isFromModel || this.myIsModelUpdateAuthorized) {
            this.myAnimatedDrawWidth.setTarget(width, time2);
            this.myAnimatedDrawHeight.setTarget(height, time2);
            if (isFromModel) {
                NlComponentHelperKt.setW(this.myNlComponent, Coordinates.dpToPx(this.myNlComponent.getModel(), (float)width));
                NlComponentHelperKt.setH(this.myNlComponent, Coordinates.dpToPx(this.myNlComponent.getModel(), (float)height));
            }
        }
    }

    @NotNull
    public NlComponent getAuthoritativeNlComponent() {
        if (this.myComponentProvider != null) {
            return this.myComponentProvider.getComponent(this);
        }
        return this.myNlComponent;
    }

    @NotNull
    public NlComponent getNlComponent() {
        return this.myNlComponent;
    }

    @NotNull
    public Scene getScene() {
        return this.myScene;
    }

    public ArrayList<SceneComponent> getChildren() {
        return this.myChildren;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    public SceneComponent getChild(int i) {
        return this.myChildren.get(i);
    }

    public void setToolLocked(boolean locked) {
        this.myIsToolLocked = locked;
    }

    public boolean isToolLocked() {
        return this.myIsToolLocked;
    }

    @NotNull
    public Stream<SceneComponent> flatten() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(SceneComponent::flatten));
    }

    public void setDrawState(@NotNull DrawState drawState) {
        DrawState oldState = this.myDrawState;
        this.myDrawState = drawState;
        if (this.myIsSelected) {
            this.myDrawState = DrawState.SELECTED;
        }
        if (oldState != this.myDrawState) {
            DecoratorUtilities.setTimeChange(this.myNlComponent, "view", DecoratorUtilities.mapState(drawState));
        }
    }

    public int getBaseline() {
        return Coordinates.pxToDp(this.myNlComponent.getModel(), NlComponentHelperKt.getBaseline(this.myNlComponent));
    }

    public void setSelected(boolean selected) {
        if (!selected || !this.myIsSelected) {
            this.myShowBaseline = false;
        }
        this.myIsSelected = selected;
        if (this.myIsSelected) {
            this.setDrawState(DrawState.SELECTED);
        } else {
            this.setDrawState(DrawState.NORMAL);
        }
        for (Target target : this.myTargets) {
            target.setComponentSelection(this.myIsSelected);
        }
    }

    public void setDragging(boolean dragging) {
        if (!this.getNlComponent().isRoot()) {
            this.myDragging = dragging;
        }
    }

    public boolean isDragging() {
        return this.myDragging;
    }

    public DrawState getDrawState() {
        return this.myDrawState;
    }

    public List<Target> getTargets() {
        assert (ApplicationManager.getApplication().isDispatchThread());
        return Collections.unmodifiableList(this.myTargets);
    }

    public SceneDecorator getDecorator() {
        return this.myDecorator;
    }

    public Notch.Provider getNotchProvider() {
        return this.myNotchProvider;
    }

    public void setNotchProvider(Notch.Provider notchProvider) {
        this.myNotchProvider = notchProvider;
    }

    public void setExpandTargetArea(boolean expandArea) {
        for (Target target : this.myTargets) {
            target.setExpandSize(expandArea);
        }
        this.myScene.needsRebuildList();
    }

    ResizeBaseTarget getResizeTarget(ResizeBaseTarget.Type type) {
        int count = this.myTargets.size();
        for (int i = 0; i < count; ++i) {
            ResizeBaseTarget target;
            if (!(this.myTargets.get(i) instanceof ResizeBaseTarget) || (target = (ResizeBaseTarget)this.myTargets.get(i)).getType() != type) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId.equalsIgnoreCase(this.myNlComponent.getId())) {
            return this;
        }
        int count = this.myChildren.size();
        for (int i = 0; i < count; ++i) {
            SceneComponent child = this.myChildren.get(i);
            SceneComponent found = child.getSceneComponent(componentId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull NlComponent nlComponent) {
        if (nlComponent == this.myNlComponent) {
            return this;
        }
        for (SceneComponent child : this.getChildren()) {
            SceneComponent found = child.getSceneComponent(nlComponent);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.intersects(this.fillRect(null));
    }

    public void clearAttributes() {
        NlComponent component2 = this.getAuthoritativeNlComponent();
        ViewGroupHandler viewGroupHandler = NlComponentHelperKt.getViewGroupHandler(component2);
        viewGroupHandler.clearAttributes(component2);
        for (SceneComponent child : this.getChildren()) {
            viewGroupHandler.clearAttributes(child.getAuthoritativeNlComponent());
        }
    }

    protected void addTarget(@NotNull Target target) {
        target.setComponent(this);
        this.myTargets.add(target);
    }

    public void addChild(@NotNull SceneComponent child) {
        child.removeFromParent();
        child.setParent(this);
        this.myChildren.add(child);
    }

    public void removeFromParent() {
        if (this.myParent != null) {
            this.myParent.remove(this);
        }
    }

    private void remove(@NotNull SceneComponent component2) {
        this.myChildren.remove(component2);
    }

    public void markSelection(List<NlComponent> components) {
        int count = components.size();
        boolean selected = false;
        for (int i = 0; i < count; ++i) {
            NlComponent component2 = components.get(i);
            if (this.myNlComponent != component2) continue;
            selected = true;
            break;
        }
        this.setSelected(selected);
        int childCount = this.myChildren.size();
        for (int i = 0; i < childCount; ++i) {
            SceneComponent child = this.myChildren.get(i);
            child.markSelection(components);
        }
    }

    public boolean layout(@NotNull SceneContext sceneTransform, long time2) {
        boolean needsRebuildDisplayList = false;
        int left = this.myAnimatedDrawX.getValue(time2);
        int top = this.myAnimatedDrawY.getValue(time2);
        int right = left + this.myAnimatedDrawWidth.getValue(time2);
        int bottom = top + this.myAnimatedDrawHeight.getValue(time2);
        needsRebuildDisplayList |= this.myCurrentLeft != left;
        needsRebuildDisplayList |= this.myCurrentTop != top;
        needsRebuildDisplayList |= this.myCurrentRight != right;
        needsRebuildDisplayList |= this.myCurrentBottom != bottom;
        this.myCurrentLeft = left;
        this.myCurrentTop = top;
        this.myCurrentRight = right;
        this.myCurrentBottom = bottom;
        boolean animating = false;
        animating |= this.myAnimatedDrawX.isAnimating();
        animating |= this.myAnimatedDrawY.isAnimating();
        animating |= this.myAnimatedDrawWidth.isAnimating();
        needsRebuildDisplayList |= (animating |= this.myAnimatedDrawHeight.isAnimating());
        int num = this.myTargets.size();
        for (int i = 0; i < num; ++i) {
            Target target = this.myTargets.get(i);
            needsRebuildDisplayList |= target.layout(sceneTransform, this.myCurrentLeft, this.myCurrentTop, this.myCurrentRight, this.myCurrentBottom);
        }
        int childCount = this.myChildren.size();
        for (int i = 0; i < childCount; ++i) {
            SceneComponent child = this.myChildren.get(i);
            needsRebuildDisplayList |= child.layout(sceneTransform, time2);
        }
        return needsRebuildDisplayList;
    }

    public Rectangle fillRect(@Nullable Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = this.myCurrentLeft;
        rectangle.y = this.myCurrentTop;
        rectangle.width = this.myCurrentRight - this.myCurrentLeft;
        rectangle.height = this.myCurrentBottom - this.myCurrentTop;
        return rectangle;
    }

    public void addHit(@NotNull SceneContext sceneTransform, @NotNull ScenePicker picker) {
        if (this.myIsToolLocked) {
            return;
        }
        if (this.myDrawState == DrawState.HOVER) {
            this.myDrawState = DrawState.NORMAL;
        }
        picker.addRect(this, 0, sceneTransform.getSwingX(this.myCurrentLeft), sceneTransform.getSwingY(this.myCurrentTop), sceneTransform.getSwingX(this.myCurrentRight), sceneTransform.getSwingY(this.myCurrentBottom));
        int num = this.myTargets.size();
        for (int i = 0; i < num; ++i) {
            Target target = this.myTargets.get(i);
            target.addHit(sceneTransform, picker);
        }
        int childCount = this.myChildren.size();
        for (int i = 0; i < childCount; ++i) {
            SceneComponent child = this.myChildren.get(i);
            if (child instanceof TemporarySceneComponent) continue;
            child.addHit(sceneTransform, picker);
        }
    }

    public void buildDisplayList(long time2, @NotNull DisplayList list, SceneContext sceneContext) {
        this.myDecorator.buildList(list, time2, sceneContext, this);
    }

    @NotNull
    public Rectangle fillDrawRect(long time2, @Nullable Rectangle rec) {
        if (rec == null) {
            rec = new Rectangle();
        }
        rec.x = this.getDrawX(time2);
        rec.y = this.getDrawY(time2);
        rec.width = this.getDrawWidth(time2);
        rec.height = this.getDrawHeight(time2);
        return rec;
    }

    public String getId() {
        return this.myNlComponent.getId();
    }

    public String getComponentClassName() {
        ViewInfo info = NlComponentHelperKt.getViewInfo(this.myNlComponent);
        if (info == null) {
            return null;
        }
        return info.getClassName();
    }

    public boolean containsX(int xDp) {
        return this.getDrawX() <= xDp && xDp <= this.getDrawX() + this.getDrawWidth();
    }

    public boolean containsY(int yDp) {
        return this.getDrawY() <= yDp && yDp <= this.getDrawY() + this.getDrawHeight();
    }

    public void setTargetProvider(@Nullable TargetProvider targetProvider, boolean isParent) {
        if (this.myTargetProvider == targetProvider) {
            return;
        }
        this.myTargetProvider = targetProvider;
        this.myTargets.clear();
        if (this.myTargetProvider != null) {
            this.myTargetProvider.createTargets(this, isParent).forEach(this::addTarget);
        }
    }

    public void setComponentProvider(@NotNull ComponentProvider provider) {
        this.myComponentProvider = provider;
    }

    public void updateTargets(boolean isParent) {
        this.myTargets.clear();
        if (this.myTargetProvider != null) {
            this.myTargetProvider.createTargets(this, isParent).forEach(this::addTarget);
        }
        for (SceneComponent child : this.getChildren()) {
            child.updateTargets(false);
        }
    }

    public void setModelUpdateAuthorized(boolean modelUpdateAuthorized) {
        this.myIsModelUpdateAuthorized = modelUpdateAuthorized;
    }

    static class AnimatedValue {
        int value;
        int target;
        long startTime;
        int duration = 350;

        AnimatedValue() {
        }

        public void setValue(int v) {
            this.value = v;
            this.target = v;
            this.startTime = 0L;
        }

        public void setTarget(int v, long time2) {
            if (this.target == v) {
                return;
            }
            this.startTime = time2;
            this.target = v;
        }

        public int getValue(long time2) {
            if (this.startTime == 0L) {
                this.target = this.value;
                return this.value;
            }
            float progress = (float)(time2 - this.startTime) / (float)this.duration;
            if (progress >= 1.0f) {
                this.value = this.target;
                return this.value;
            }
            if (progress <= 0.0f) {
                return this.value;
            }
            return (int)(0.5 + this.EaseInOutInterpolator(progress, this.value, this.target));
        }

        public boolean isAnimating() {
            return this.value != this.target;
        }

        double EaseInOutInterpolator(double progress, double begin, double end) {
            double change = (end - begin) / 2.0;
            if ((progress *= 2.0) < 1.0) {
                return change * progress * progress + begin;
            }
            return -change * ((progress -= 1.0) * (progress - 2.0) - 1.0) + begin;
        }
    }

    public static enum DrawState {
        SUBDUED,
        NORMAL,
        HOVER,
        SELECTED,
        DRAG;

    }
}

