/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragDndTarget;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneManager
implements Disposable {
    public static final boolean SUPPORTS_LOCKING = false;
    private final NlModel myModel;
    private final DesignSurface myDesignSurface;
    private Scene myScene;

    public SceneManager(NlModel model, DesignSurface surface) {
        this.myModel = model;
        this.myDesignSurface = surface;
        Disposer.register((Disposable)model, (Disposable)this);
    }

    public void dispose() {
    }

    @NotNull
    public Scene build() {
        assert (this.myScene == null);
        this.myScene = new Scene(this, this.myDesignSurface);
        return this.myScene;
    }

    public void update() {
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        Scene scene = this.getScene();
        if (components.isEmpty()) {
            scene.removeAllComponents();
            scene.setRoot(null);
            return;
        }
        HashSet<SceneComponent> usedComponents = new HashSet<SceneComponent>();
        HashSet<SceneComponent> oldComponents = new HashSet<SceneComponent>(scene.getSceneComponents());
        NlComponent rootComponent = this.getRoot();
        if (this.myScene.getRoot() != null && rootComponent != this.myScene.getRoot().getNlComponent()) {
            scene.removeAllComponents();
            scene.setRoot(null);
        }
        SceneComponent root = this.createHierarchy(rootComponent);
        scene.setRoot(root);
        if (root != null) {
            this.updateFromComponent(root, usedComponents);
        }
        oldComponents.removeAll(usedComponents);
        oldComponents.removeIf(component2 -> component2 instanceof TemporarySceneComponent);
        oldComponents.forEach(scene::removeComponent);
        scene.needsRebuildList();
    }

    @NotNull
    protected NlComponent getRoot() {
        return ((NlComponent)this.getModel().getComponents().get(0)).getRoot();
    }

    public static boolean isComponentLocked(@NotNull NlComponent component2) {
        return false;
    }

    @Nullable
    protected SceneComponent createHierarchy(@NotNull NlComponent component2) {
        SceneComponent sceneComponent = this.getScene().getSceneComponent(component2);
        if (sceneComponent == null) {
            sceneComponent = new SceneComponent(this.getScene(), component2);
        }
        sceneComponent.setToolLocked(SceneManager.isComponentLocked(component2));
        HashSet<SceneComponent> oldChildren = new HashSet<SceneComponent>(sceneComponent.getChildren());
        for (NlComponent nlChild : component2.getChildren()) {
            SceneComponent child = this.createHierarchy(nlChild);
            oldChildren.remove(child);
            if (child == null || child.getParent() == sceneComponent) continue;
            sceneComponent.addChild(child);
        }
        for (SceneComponent child : oldChildren) {
            if (child.getParent() != sceneComponent) continue;
            child.removeFromParent();
        }
        return sceneComponent;
    }

    protected final void updateFromComponent(@NotNull SceneComponent component2, @NotNull Set<SceneComponent> seenComponents) {
        seenComponents.add(component2);
        this.updateFromComponent(component2);
        for (SceneComponent child : component2.getChildren()) {
            this.updateFromComponent(child, seenComponents);
        }
        this.postUpdateFromComponent(component2);
    }

    protected void postUpdateFromComponent(@NotNull SceneComponent component2) {
    }

    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component2) {
        Scene scene = this.getScene();
        assert (scene.getRoot() != null);
        TemporarySceneComponent tempComponent = new TemporarySceneComponent(this.getScene(), component2);
        tempComponent.addTarget(new ConstraintDragDndTarget());
        scene.setAnimated(false);
        scene.getRoot().addChild(tempComponent);
        this.updateFromComponent(tempComponent);
        scene.setAnimated(true);
        return tempComponent;
    }

    protected void updateFromComponent(SceneComponent sceneComponent) {
        sceneComponent.setToolLocked(false);
    }

    @NotNull
    protected DesignSurface getDesignSurface() {
        return this.myDesignSurface;
    }

    @NotNull
    protected NlModel getModel() {
        return this.myModel;
    }

    @NotNull
    protected Scene getScene() {
        assert (this.myScene != null);
        return this.myScene;
    }

    public abstract void requestRender();

    public abstract void layout(boolean var1);

    @NotNull
    public abstract SceneDecoratorFactory getSceneDecoratorFactory();

    public abstract Map<Object, PropertiesMap> getDefaultProperties();
}

