/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.decorator;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneFrameFactory;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawComponentBackground;
import com.android.tools.idea.common.scene.draw.DrawComponentFrame;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SceneDecorator {
    private SceneFrameFactory myFrameFactory = (list, component2, sceneContext) -> {
        Rectangle rect = new Rectangle();
        component2.fillRect(rect);
        SceneComponent.DrawState mode = component2.getDrawState();
        DrawComponentFrame.add(list, sceneContext, rect, mode.ordinal());
    };

    public void setFrameFactory(@NotNull SceneFrameFactory sceneFrameFactory) {
        this.myFrameFactory = sceneFrameFactory;
    }

    public void buildList(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        if (sceneContext.showOnlySelection()) {
            this.addFrame(list, sceneContext, component2);
            this.buildListChildren(list, time2, sceneContext, component2);
            return;
        }
        this.buildListComponent(list, time2, sceneContext, component2);
        this.buildListTargets(list, time2, sceneContext, component2);
        this.buildListChildren(list, time2, sceneContext, component2);
    }

    public void buildListComponent(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        this.addBackground(list, sceneContext, component2);
        this.addContent(list, time2, sceneContext, component2);
        this.addFrame(list, sceneContext, component2);
    }

    protected void addContent(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
    }

    protected void addBackground(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        if (sceneContext.getColorSet().drawBackground()) {
            Rectangle rect = new Rectangle();
            component2.fillRect(rect);
            SceneComponent.DrawState state = component2.getDrawState();
            if (component2.isToolLocked()) {
                state = SceneComponent.DrawState.SUBDUED;
            }
            DrawComponentBackground.add(list, sceneContext, rect, state.ordinal());
        }
    }

    protected void addFrame(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        this.myFrameFactory.addFrame(list, component2, sceneContext);
    }

    protected void buildListChildren(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        ArrayList<SceneComponent> children = component2.getChildren();
        if (!children.isEmpty()) {
            Rectangle rect = new Rectangle();
            component2.fillRect(rect);
            DisplayList.UNClip unClip = list.addClip(sceneContext, rect);
            for (SceneComponent child : children) {
                child.buildDisplayList(time2, list, sceneContext);
            }
            list.add(unClip);
        }
    }

    protected void buildListTargets(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        component2.getTargets().forEach(target -> target.render(list, sceneContext));
    }
}

