/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawAction;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.graphics.NlIcon;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionTarget
extends BaseTarget {
    static final int mySize = 12;
    static final int myGap = 4;
    final ActionTarget myPreviousActionTarget;
    @Nullable
    private Action myAction;
    @NotNull
    private final NlIcon myIcon;
    protected boolean myIsVisible = true;

    public ActionTarget(@Nullable ActionTarget previous, @NotNull NlIcon icon, @Nullable Action action) {
        this.myPreviousActionTarget = previous;
        this.myIcon = icon;
        this.myAction = action;
    }

    public void setAction(@Nullable Action action) {
        this.myAction = action;
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    @Override
    public int getPreferenceLevel() {
        return 80;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        float ratio = 1.0f / (float)sceneTransform.getScale();
        if (ratio > 2.0f) {
            ratio = 2.0f;
        }
        this.myLeft = this.myPreviousActionTarget == null ? (float)l : (!this.myPreviousActionTarget.myIsVisible ? this.myPreviousActionTarget.myRight : this.myPreviousActionTarget.myRight + 4.0f * ratio);
        float size = 12.0f * ratio;
        this.myTop = (float)b + 4.0f * ratio;
        this.myRight = this.myLeft + size;
        this.myBottom = this.myTop + size;
        if (!this.myIsVisible) {
            this.myRight = this.myLeft = this.myPreviousActionTarget == null ? this.myLeft : this.myPreviousActionTarget.myRight;
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (!this.myComponent.getScene().allowsTarget(this)) {
            return;
        }
        if (this.myIsVisible) {
            Rectangle src = new Rectangle();
            this.myComponent.fillRect(src);
            DrawAction.add(list, sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, src, this.myIcon, this.mIsOver);
        }
    }

    @Override
    public void mouseDown(int x, int y) {
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable List<Target> closestTarget) {
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        if (this.myAction != null && closestTargets.contains(this)) {
            this.myAction.apply(this.myComponent);
            this.myComponent.getScene().needsRebuildList();
        }
    }

    public static interface Action {
        public void apply(SceneComponent var1);
    }
}

