/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.target.Target;
import java.awt.Cursor;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTarget
implements Target {
    protected SceneComponent myComponent;
    protected float myLeft = 0.0f;
    protected float myTop = 0.0f;
    protected float myRight = 0.0f;
    protected float myBottom = 0.0f;
    protected boolean mIsOver = false;

    @Override
    public boolean canChangeSelection() {
        return true;
    }

    @Override
    public void setComponent(@NotNull SceneComponent component2) {
        this.myComponent = component2;
    }

    @Override
    public SceneComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public void setOver(boolean over) {
        if (over != this.mIsOver && this.myComponent != null) {
            this.myComponent.getScene().repaint();
        }
        this.mIsOver = over;
    }

    @Override
    public void setExpandSize(boolean expand) {
    }

    @Override
    public float getCenterX() {
        return this.myLeft + (this.myRight - this.myLeft) / 2.0f;
    }

    @Override
    public float getCenterY() {
        return this.myTop + (this.myBottom - this.myTop) / 2.0f;
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getDefaultCursor();
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker) {
        if (!this.myComponent.getScene().allowsTarget(this)) {
            return;
        }
        picker.addRect(this, 0, transform.getSwingX(this.myLeft), transform.getSwingY(this.myTop), transform.getSwingX(this.myRight), transform.getSwingY(this.myBottom));
    }

    @Override
    public String getToolTipText() {
        String str = this.myComponent.getNlComponent().getId();
        if (str == null && (str = this.myComponent.getComponentClassName()) != null) {
            str = str.substring(str.lastIndexOf(46) + 1);
        }
        return str;
    }

    protected void applyAndCommit(@NotNull AttributesTransaction attributes, @NotNull String label) {
        attributes.apply();
        NlWriteCommandAction.run(attributes.getComponent(), label, attributes::commit);
        this.myComponent.getScene().needsLayout(2);
    }

    @Override
    public void setComponentSelection(boolean selection) {
    }
}

