/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.MultiComponentTarget;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DragBaseTarget
extends BaseTarget
implements Notch.Snappable,
MultiComponentTarget {
    private static final boolean DEBUG_RENDERER = false;
    protected int myOffsetX;
    protected int myOffsetY;
    protected int myFirstMouseX;
    protected int myFirstMouseY;
    protected boolean myChangedComponent;
    private final Point mySnappedCoordinates = new Point();
    private final TargetSnapper myTargetSnapper;

    private DragBaseTarget(@NotNull TargetSnapper targetSnapper) {
        this.myTargetSnapper = targetSnapper;
    }

    public DragBaseTarget() {
        this(new TargetSnapper());
    }

    @Override
    public boolean canChangeSelection() {
        return true;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        int d;
        int minWidth = 16;
        int minHeight = 16;
        if (r - l < minWidth) {
            d = (minWidth - (r - l)) / 2;
            l -= d;
            r += d;
        }
        if (b - t < minHeight) {
            d = (minHeight - (b - t)) / 2;
            t -= d;
            b += d;
        }
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        this.myTargetSnapper.renderCurrentNotches(list, sceneContext, this.myComponent);
    }

    protected abstract void updateAttributes(@NotNull AttributesTransaction var1, int var2, int var3);

    @Override
    public int getPreferenceLevel() {
        return 20;
    }

    @Override
    public void mouseDown(int x, int y) {
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myFirstMouseX = x;
        this.myFirstMouseY = y;
        this.myOffsetX = x - this.myComponent.getDrawX(System.currentTimeMillis());
        this.myOffsetY = y - this.myComponent.getDrawY(System.currentTimeMillis());
        this.myChangedComponent = false;
        this.getTargetNotchSnapper().gatherNotches(this.myComponent);
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable List<Target> closestTargets) {
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myComponent.setDragging(true);
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction attributes = component2.startAttributeTransaction();
        this.mySnappedCoordinates.x = this.myTargetSnapper.trySnapX(x - this.myOffsetX);
        this.mySnappedCoordinates.y = this.myTargetSnapper.trySnapY(y - this.myOffsetY);
        this.updateAttributes(attributes, this.mySnappedCoordinates.x, this.mySnappedCoordinates.y);
        attributes.apply();
        component2.fireLiveChangeEvent();
        this.myComponent.getScene().needsLayout(1);
        this.myChangedComponent = true;
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        if (!this.myComponent.isDragging()) {
            return;
        }
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            boolean commitChanges = true;
            if (Math.abs(x - this.myFirstMouseX) <= 1 && Math.abs(y - this.myFirstMouseY) <= 1) {
                commitChanges = false;
            }
            NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
            AttributesTransaction attributes = component2.startAttributeTransaction();
            this.mySnappedCoordinates.x = this.myTargetSnapper.trySnapX(x - this.myOffsetX);
            this.mySnappedCoordinates.y = this.myTargetSnapper.trySnapY(y - this.myOffsetY);
            this.myTargetSnapper.applyNotches(this.myComponent, attributes, this.mySnappedCoordinates);
            this.updateAttributes(attributes, this.mySnappedCoordinates.x, this.mySnappedCoordinates.y);
            attributes.apply();
            if (commitChanges) {
                NlWriteCommandAction.run(component2, "Dragged " + StringUtil.getShortName((String)component2.getTagName()), attributes::commit);
            }
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().needsLayout(1);
        }
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    @NotNull
    public TargetSnapper getTargetNotchSnapper() {
        return this.myTargetSnapper;
    }

    public boolean hasChangedComponent() {
        return this.myChangedComponent;
    }
}

