/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionManager;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.PanZoomListener;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ZoomType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.error.IssueModel;
import com.android.tools.idea.uibuilder.error.IssuePanel;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProviders;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.ConstraintsLayer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.Alarm;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignSurface
extends EditorDesignSurface
implements Disposable,
DataProvider {
    private static final Integer LAYER_PROGRESS = JLayeredPane.POPUP_LAYER + 100;
    private final Project myProject;
    protected double myScale = 1.0;
    @NotNull
    protected final JScrollPane myScrollPane;
    private final MyLayeredPane myLayeredPane;
    protected boolean myDeviceFrames = false;
    private ImmutableList<Layer> myLayers = ImmutableList.of();
    private final InteractionManager myInteractionManager;
    private final GlassPane myGlassPane;
    protected final List<DesignSurfaceListener> myListeners = new ArrayList<DesignSurfaceListener>();
    private List<PanZoomListener> myZoomListeners;
    private final ActionManager myActionManager;
    @NotNull
    private WeakReference<FileEditor> myFileEditorDelegate = new WeakReference<Object>(null);
    protected NlModel myModel;
    protected Scene myScene;
    private SceneManager mySceneManager;
    private final SelectionModel mySelectionModel;
    private ViewEditorImpl myViewEditor;
    private final IssueModel myIssueModel = new IssueModel();
    private final IssuePanel myIssuePanel;
    private final JBSplitter myErrorPanelSplitter;
    private final Object myErrorQueueLock = new Object();
    private MergingUpdateQueue myErrorQueue;
    private boolean myIsActive = false;
    private final SelectionListener mySelectionListener = (model, selection) -> {
        if (this.getCurrentSceneView() != null) {
            this.notifySelectionListeners(selection);
        } else {
            this.notifySelectionListeners(Collections.emptyList());
        }
    };
    private final ModelListener myModelListener = new ModelListener(){

        @Override
        public void modelRendered(@NotNull NlModel model) {
            DesignSurface.this.modelRendered(model);
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            DesignSurface.this.repaint();
        }
    };
    private final List<ProgressIndicator> myProgressIndicators = new ArrayList<ProgressIndicator>();
    private final MyProgressPanel myProgressPanel;

    public DesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable) {
        super(new BorderLayout());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.setOpaque(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.mySelectionModel = new SelectionModel();
        this.myInteractionManager = new InteractionManager(this);
        this.myLayeredPane = new MyLayeredPane();
        this.myLayeredPane.setBounds(0, 0, 100, 100);
        this.myGlassPane = new GlassPane();
        this.myLayeredPane.add((Component)this.myGlassPane, JLayeredPane.DRAG_LAYER);
        this.myProgressPanel = new MyProgressPanel();
        this.myProgressPanel.setName("Layout Editor Progress Panel");
        this.myLayeredPane.add((Component)this.myProgressPanel, LAYER_PROGRESS);
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.setViewportView(this.myLayeredPane);
        this.myScrollPane.setBorder(null);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(32);
        this.myScrollPane.getHorizontalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myIssuePanel = new IssuePanel(this, this.myIssueModel);
        Disposer.register((Disposable)this, (Disposable)this.myIssuePanel);
        this.myIssuePanel.setMinimizeListener(isMinimized -> {
            NlUsageTrackerManager.getInstance(this).logAction(isMinimized ? LayoutEditorEvent.LayoutEditorEventType.MINIMIZE_ERROR_PANEL : LayoutEditorEvent.LayoutEditorEventType.RESTORE_ERROR_PANEL);
            this.updateErrorPanelSplitterUi(isMinimized);
        });
        this.myErrorPanelSplitter = new OnePixelSplitter(true, 0.75f, 0.5f, 1.0f);
        this.myErrorPanelSplitter.setHonorComponentsMinimumSize(true);
        this.myErrorPanelSplitter.setFirstComponent((JComponent)this.myScrollPane);
        this.myErrorPanelSplitter.setSecondComponent((JComponent)this.myIssuePanel);
        this.add((Component)this.myErrorPanelSplitter);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (DesignSurface.this.isShowing() && DesignSurface.this.getWidth() > 0 && DesignSurface.this.getHeight() > 0 && DesignSurface.this.getFitScale(false) > DesignSurface.this.myScale) {
                    DesignSurface.this.zoomToFit();
                } else {
                    DesignSurface.this.layoutContent();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.myInteractionManager.registerListeners();
        this.myActionManager = this.createActionManager();
        this.myActionManager.registerActions(this.myLayeredPane);
    }

    @NotNull
    protected abstract ActionManager<? extends DesignSurface> createActionManager();

    @NotNull
    protected abstract SceneManager createSceneManager(@NotNull NlModel var1);

    protected abstract void layoutContent();

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public NlLayoutType getLayoutType() {
        if (this.getCurrentSceneView() == null) {
            return NlLayoutType.UNKNOWN;
        }
        return NlLayoutType.typeOf(this.getCurrentSceneView().getModel().getFile());
    }

    @NotNull
    public ActionManager getActionManager() {
        return this.myActionManager;
    }

    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    protected final void createSceneViews() {
        this.doCreateSceneViews();
        this.notifySceneViewChanged();
    }

    protected abstract void doCreateSceneViews();

    @Nullable
    public NlModel getModel() {
        return this.myModel;
    }

    public void setModel(@Nullable NlModel model) {
        SelectionModel selectionModel;
        this.myModel = model;
        SceneView sceneView = this.getCurrentSceneView();
        if (model == null && sceneView == null) {
            return;
        }
        List selectionBefore = Collections.emptyList();
        List<NlComponent> selectionAfter = Collections.emptyList();
        if (sceneView != null) {
            sceneView.getModel().removeListener(this.myModelListener);
            selectionModel = sceneView.getSelectionModel();
            selectionBefore = selectionModel.getSelection();
            selectionModel.removeListener(this.mySelectionListener);
        }
        if (model != null) {
            model.addListener(this.myModelListener);
            this.mySceneManager = this.createSceneManager(model);
            this.myScene = this.mySceneManager.build();
        } else {
            this.myScene = null;
            this.mySceneManager = null;
        }
        this.createSceneViews();
        if (model != null) {
            selectionModel = model.getSelectionModel();
            selectionModel.addListener(this.mySelectionListener);
            selectionAfter = selectionModel.getSelection();
            if (this.myInteractionManager.isListening() && !this.getLayoutType().isSupportedByDesigner()) {
                this.myInteractionManager.unregisterListeners();
            } else if (!this.myInteractionManager.isListening() && this.getLayoutType().isSupportedByDesigner()) {
                this.myInteractionManager.registerListeners();
            }
        }
        this.repaint();
        if (!selectionBefore.equals(selectionAfter)) {
            this.notifySelectionListeners(selectionAfter);
        }
        for (DesignSurfaceListener listener : ImmutableList.copyOf(this.myListeners)) {
            listener.modelChanged(this, model);
        }
        this.notifySceneViewChanged();
        this.zoomToFit();
    }

    public void dispose() {
        this.setLayers((ImmutableList<Layer>)ImmutableList.of());
    }

    @Nullable
    public abstract Dimension getScrolledAreaSize();

    @Nullable
    public Dimension updateScrolledAreaSize() {
        Dimension dimension = this.getScrolledAreaSize();
        if (dimension == null) {
            return null;
        }
        this.myLayeredPane.setSize(dimension.width, dimension.height);
        this.myLayeredPane.setPreferredSize(dimension);
        this.myScrollPane.revalidate();
        SceneView view = this.getCurrentSceneView();
        if (view != null) {
            this.myProgressPanel.setBounds(this.getContentOriginX(), this.getContentOriginY(), view.getSize().width, view.getSize().height);
        }
        return dimension;
    }

    protected abstract int getContentOriginX();

    protected abstract int getContentOriginY();

    public JComponent getPreferredFocusedComponent() {
        return this.myGlassPane;
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.isFocusOwner()) {
            graphics.setColor(UIUtil.getFocusedBoundsColor());
            graphics.drawRect(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    @Nullable
    public abstract SceneView getCurrentSceneView();

    public void startDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            SceneLayer sceneLayer;
            ConstraintsLayer constraintsLayer;
            if (layer instanceof ConstraintsLayer && !(constraintsLayer = (ConstraintsLayer)layer).isShowOnHover()) {
                constraintsLayer.setShowOnHover(true);
                this.repaint();
            }
            if (!(layer instanceof SceneLayer) || (sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(true);
            this.repaint();
        }
    }

    public void stopDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            SceneLayer sceneLayer;
            ConstraintsLayer constraintsLayer;
            if (layer instanceof ConstraintsLayer && (constraintsLayer = (ConstraintsLayer)layer).isShowOnHover()) {
                constraintsLayer.setShowOnHover(false);
                this.repaint();
            }
            if (!(layer instanceof SceneLayer) || (sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(false);
            this.repaint();
        }
    }

    @NotNull
    public abstract Dimension getContentSize(@Nullable Dimension var1);

    public void hover(int x, int y) {
        for (Layer layer : this.myLayers) {
            layer.hover(x, y);
        }
    }

    public void zoom(@NotNull ZoomType type) {
        this.zoom(type, -1, -1);
    }

    public void zoom(@NotNull ZoomType type, int x, int y) {
        SceneComponent component2;
        Scene scene;
        SceneView view = this.getCurrentSceneView();
        if (!(type != ZoomType.IN || x >= 0 && y >= 0 || view == null || this.getSelectionModel().isEmpty() || (scene = this.getScene()) == null || (component2 = scene.getSceneComponent(this.getSelectionModel().getPrimary())) == null)) {
            x = Coordinates.getSwingXDip(view, component2.getCenterX());
            y = Coordinates.getSwingYDip(view, component2.getCenterY());
        }
        switch (type) {
            case IN: {
                double currentScale = this.myScale;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    currentScale *= 2.0;
                }
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomIn(current) / 100.0;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    scale /= 2.0;
                }
                this.setScale(scale, x, y);
                this.repaint();
                break;
            }
            case OUT: {
                double currentScale = this.myScale;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    currentScale *= 2.0;
                }
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomOut(current) / 100.0;
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    scale /= 2.0;
                }
                this.setScale(scale);
                this.repaint();
                break;
            }
            case ACTUAL: {
                if (SystemInfo.isMac && UIUtil.isRetina()) {
                    this.setScale(0.5);
                } else {
                    this.setScale(1.0);
                }
                this.repaint();
                break;
            }
            case FIT: 
            case FIT_INTO: {
                if (this.getCurrentSceneView() == null) {
                    return;
                }
                this.setScale(this.getFitScale(type == ZoomType.FIT_INTO));
                this.repaint();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented: " + (Object)((Object)type));
            }
        }
    }

    protected double getFitScale(boolean fitInto) {
        int availableWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth();
        int availableHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight();
        Dimension padding = this.getDefaultOffset();
        Dimension preferredSize = this.getPreferredContentSize(availableWidth -= padding.width, availableHeight -= padding.height);
        double scaleX = preferredSize.width == 0 ? 1.0 : (double)availableWidth / (double)preferredSize.width;
        double scaleY = preferredSize.height == 0 ? 1.0 : (double)availableHeight / (double)preferredSize.height;
        double scale = Math.min(scaleX, scaleY);
        if (fitInto) {
            double min = SystemInfo.isMac && UIUtil.isRetina() ? 0.5 : 1.0;
            scale = Math.min(min, scale);
        }
        return scale;
    }

    protected abstract Dimension getDefaultOffset();

    @NotNull
    protected abstract Dimension getPreferredContentSize(int var1, int var2);

    public void zoomActual() {
        this.zoom(ZoomType.ACTUAL);
    }

    public void zoomIn() {
        this.zoom(ZoomType.IN);
    }

    public void zoomOut() {
        this.zoom(ZoomType.OUT);
    }

    public void zoomToFit() {
        this.zoom(ZoomType.FIT);
    }

    public double getScale() {
        return this.myScale;
    }

    public void setScrollPosition(int x, int y) {
        this.setScrollPosition(new Point(x, y));
    }

    public void setScrollPosition(Point p) {
        JScrollBar horizontalScrollBar = this.myScrollPane.getHorizontalScrollBar();
        JScrollBar verticalScrollBar = this.myScrollPane.getVerticalScrollBar();
        p.setLocation(Math.max(horizontalScrollBar.getMinimum(), p.x), Math.max(verticalScrollBar.getMinimum(), p.y));
        p.setLocation(Math.min(horizontalScrollBar.getMaximum() - horizontalScrollBar.getVisibleAmount(), p.x), Math.min(verticalScrollBar.getMaximum() - verticalScrollBar.getVisibleAmount(), p.y));
        this.myScrollPane.getViewport().setViewPosition(p);
    }

    public Point getScrollPosition() {
        return this.myScrollPane.getViewport().getViewPosition();
    }

    private void setScale(double scale) {
        this.setScale(scale, -1, -1);
    }

    private void setScale(double scale, int x, int y) {
        Point viewPortTargetCoordinates;
        if (scale < 0.0) {
            scale = -1.0;
        } else if (Math.abs(scale - 1.0) < 1.0E-4) {
            scale = 1.0;
        } else if (scale > 10.0) {
            scale = 10.0;
        }
        this.myScale = Math.max(scale, this.getMinScale());
        Dimension oldSize = this.myScrollPane.getViewport().getViewSize();
        if (x < 0 || y < 0) {
            Point viewPortPosition = this.myScrollPane.getViewport().getViewPosition();
            x = viewPortPosition.x + this.myScrollPane.getWidth() / 2;
            y = viewPortPosition.y + this.myScrollPane.getHeight() / 2;
            viewPortTargetCoordinates = new Point(this.myScrollPane.getWidth() / 2, this.myScrollPane.getHeight() / 2);
        } else {
            viewPortTargetCoordinates = SwingUtilities.convertPoint(this.myLayeredPane, x, y, this.myScrollPane.getViewport());
        }
        double nx = (double)x / (double)oldSize.width;
        double ny = (double)y / (double)oldSize.height;
        this.layoutContent();
        Dimension newSize = this.updateScrolledAreaSize();
        if (newSize != null) {
            viewPortTargetCoordinates.setLocation(nx * newSize.getWidth() - (double)viewPortTargetCoordinates.x, ny * newSize.getHeight() - (double)viewPortTargetCoordinates.y);
            this.myScrollPane.getViewport().setViewPosition(viewPortTargetCoordinates);
            this.notifyScaleChanged();
        }
    }

    protected double getMinScale() {
        return 0.0;
    }

    private void notifyScaleChanged() {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.zoomChanged(this);
            }
        }
    }

    private void notifyPanningChanged(AdjustmentEvent adjustmentEvent) {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.panningChanged(adjustmentEvent);
            }
        }
    }

    @NotNull
    public JComponent getLayeredPane() {
        return this.myLayeredPane;
    }

    private void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        ArrayList listeners = Lists.newArrayList(this.myListeners);
        for (DesignSurfaceListener listener : listeners) {
            listener.componentSelectionChanged(this, newSelection);
        }
    }

    private void notifySceneViewChanged() {
        SceneView screenView = this.getCurrentSceneView();
        ArrayList listeners = Lists.newArrayList(this.myListeners);
        for (DesignSurfaceListener listener : listeners) {
            listener.sceneChanged(this, screenView);
        }
    }

    public void notifyComponentActivate(@NotNull NlComponent component2, int x, int y) {
        this.notifyComponentActivate(component2);
    }

    public void notifyComponentActivate(@NotNull NlComponent component2) {
        this.activatePreferredEditor(component2);
    }

    protected void activatePreferredEditor(@NotNull NlComponent component2) {
        for (DesignSurfaceListener listener : new ArrayList<DesignSurfaceListener>(this.myListeners)) {
            if (listener.activatePreferredEditor(this, component2)) break;
        }
    }

    public void addListener(@NotNull DesignSurfaceListener listener) {
        this.myListeners.remove(listener);
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull DesignSurfaceListener listener) {
        this.myListeners.remove(listener);
    }

    protected void modelRendered(@NotNull NlModel model) {
        if (this.getCurrentSceneView() != null) {
            this.repaint();
            this.layoutContent();
        }
    }

    public void addPanZoomListener(PanZoomListener listener) {
        if (this.myZoomListeners == null) {
            this.myZoomListeners = Lists.newArrayList();
        } else {
            this.myZoomListeners.remove(listener);
        }
        this.myZoomListeners.add(listener);
    }

    public void removePanZoomListener(PanZoomListener listener) {
        if (this.myZoomListeners != null) {
            this.myZoomListeners.remove(listener);
        }
    }

    public void activate() {
        if (!this.myIsActive && this.getCurrentSceneView() != null) {
            this.getCurrentSceneView().getModel().activate(this);
        }
        this.myIsActive = true;
    }

    public void deactivate() {
        if (this.myIsActive && this.getCurrentSceneView() != null) {
            this.getCurrentSceneView().getModel().deactivate(this);
        }
        this.myIsActive = false;
        this.myInteractionManager.cancelInteraction();
    }

    public void setFileEditorDelegate(@Nullable FileEditor fileEditor) {
        this.myFileEditorDelegate = new WeakReference<FileEditor>(fileEditor);
    }

    public SceneView getSceneView(int x, int y) {
        return this.getCurrentSceneView();
    }

    @Nullable
    public SceneView getHoverSceneView(int x, int y) {
        return this.getCurrentSceneView();
    }

    public void toggleDeviceFrames() {
        this.myDeviceFrames = !this.myDeviceFrames;
        this.layoutContent();
        this.repaint();
    }

    @Nullable
    public Scene getScene() {
        return this.myScene;
    }

    @Nullable
    public SceneManager getSceneManager() {
        return this.mySceneManager;
    }

    @NotNull
    public abstract InspectorProviders getInspectorProviders(@NotNull NlPropertiesManager var1, @NotNull Disposable var2);

    @NotNull
    protected JBColor getBackgroundColor() {
        return NlConstants.DESIGN_SURFACE_BG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndicator(@NotNull ProgressIndicator indicator) {
        if (this.myProject.isDisposed() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.add(indicator);
            this.myProgressPanel.showProgressIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIndicator(@NotNull ProgressIndicator indicator) {
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.remove(indicator);
            if (this.myProgressIndicators.isEmpty()) {
                this.myProgressPanel.hideProgressIcon();
            }
        }
    }

    protected boolean useSmallProgressIcon() {
        return true;
    }

    @Override
    public void forceUserRequestedRefresh() {
        SceneManager sceneManager;
        SceneView sceneView = this.getCurrentSceneView();
        SceneManager sceneManager2 = sceneManager = sceneView != null ? sceneView.getSceneManager() : null;
        if (sceneManager instanceof LayoutlibSceneManager) {
            ((LayoutlibSceneManager)sceneManager).requestUserInitatedRender();
        }
    }

    public void requestRender() {
        SceneView sceneView = this.getCurrentSceneView();
        if (sceneView != null) {
            sceneView.getSceneManager().requestRender();
        }
    }

    @NotNull
    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public void setDesignToolTip(@Nullable String text) {
        this.myLayeredPane.setToolTipText(text);
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFileEditorDelegate.get();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return new DesignSurfaceActionHandler(this);
        }
        return null;
    }

    public abstract boolean isLayoutDisabled();

    @Nullable
    public ViewEditor getViewEditor() {
        SceneView currentSceneView = this.getCurrentSceneView();
        if (currentSceneView == null) {
            return null;
        }
        if (this.myViewEditor == null || this.myViewEditor.getSceneView() != currentSceneView) {
            this.myViewEditor = new ViewEditorImpl(currentSceneView);
        }
        return this.myViewEditor;
    }

    @Override
    @Nullable
    public Configuration getConfiguration() {
        return this.getCurrentSceneView() != null ? this.getCurrentSceneView().getConfiguration() : null;
    }

    @NotNull
    public IssueModel getIssueModel() {
        return this.myIssueModel;
    }

    @NotNull
    public IssuePanel getIssuePanel() {
        return this.myIssuePanel;
    }

    public void setShowIssuePanel(boolean show) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myIssuePanel.setMinimized(!show);
            this.updateErrorPanelSplitterUi(this.myIssuePanel.isMinimized());
            this.revalidate();
            this.repaint();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected MergingUpdateQueue getErrorQueue() {
        Object object = this.myErrorQueueLock;
        synchronized (object) {
            if (this.myErrorQueue == null) {
                this.myErrorQueue = new MergingUpdateQueue("android.error.computation", 200, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.POOLED_THREAD);
            }
            return this.myErrorQueue;
        }
    }

    private void updateErrorPanelSplitterUi(boolean isMinimized) {
        boolean showDivider = !isMinimized;
        this.myErrorPanelSplitter.setShowDividerIcon(showDivider);
        this.myErrorPanelSplitter.setShowDividerControls(showDivider);
        this.myErrorPanelSplitter.setResizeEnabled(showDivider);
        if (isMinimized) {
            this.myErrorPanelSplitter.setProportion(1.0f);
        } else {
            int height = this.myIssuePanel.getSuggestedHeight();
            float proportion = 1.0f - (float)height / (float)this.getHeight();
            this.myErrorPanelSplitter.setProportion(Math.max(0.5f, proportion));
        }
    }

    @NotNull
    public NlComponent createComponent(@NotNull XmlTag tag) {
        NlModel model = this.getModel();
        assert (model != null);
        return DesignSurface.createComponent(tag, model);
    }

    public static NlComponent createComponent(@NotNull XmlTag tag, @NotNull NlModel model) {
        return new NlComponent(model, tag);
    }

    protected void setLayers(@NotNull ImmutableList<Layer> layers) {
        this.myLayers.forEach(Disposer::dispose);
        this.myLayers = ImmutableList.copyOf(layers);
    }

    @NotNull
    protected ImmutableList<Layer> getLayers() {
        return this.myLayers;
    }

    @Nullable
    public final Interaction createInteractionOnClick(int mouseX, int mouseY) {
        SceneView sceneView = this.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        return this.doCreateInteractionOnClick(mouseX, mouseY, sceneView);
    }

    @Nullable
    public abstract Interaction doCreateInteractionOnClick(int var1, int var2, @NotNull SceneView var3);

    @Nullable
    public abstract Interaction createInteractionOnDrag(@NotNull SceneComponent var1, @Nullable SceneComponent var2);

    private class MyProgressPanel
    extends JPanel {
        private AsyncProcessIcon mySmallProgressIcon;
        private AsyncProcessIcon myLargeProgressIcon;
        private boolean mySmall;
        private boolean myProgressVisible;

        private MyProgressPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setVisible(false);
        }

        private void setSmallIcon(boolean small) {
            if (small != this.mySmall) {
                if (this.myProgressVisible && this.getComponentCount() != 0) {
                    AsyncProcessIcon oldIcon = this.getProgressIcon();
                    oldIcon.suspend();
                }
                this.mySmall = true;
                this.removeAll();
                AsyncProcessIcon icon = this.getProgressIcon();
                this.add((Component)icon, "Center");
                if (this.myProgressVisible) {
                    icon.setVisible(true);
                    icon.resume();
                }
            }
        }

        public void showProgressIcon() {
            if (!this.myProgressVisible) {
                this.setSmallIcon(DesignSurface.this.useSmallProgressIcon());
                this.myProgressVisible = true;
                this.setVisible(true);
                AsyncProcessIcon icon = this.getProgressIcon();
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.getProgressIcon(), "Center");
                } else {
                    icon.setVisible(true);
                }
                icon.resume();
            }
        }

        public void hideProgressIcon() {
            if (this.myProgressVisible) {
                this.myProgressVisible = false;
                this.setVisible(false);
                AsyncProcessIcon icon = this.getProgressIcon();
                icon.setVisible(false);
                icon.suspend();
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.setBackground((Color)JBColor.RED);
            if (!this.myProgressVisible) {
                return;
            }
            AsyncProcessIcon icon = this.getProgressIcon();
            Dimension size = icon.getPreferredSize();
            if (this.mySmall) {
                icon.setBounds(this.getWidth() - size.width - 1, 1, size.width, size.height);
            } else {
                icon.setBounds(this.getWidth() / 2 - size.width / 2, this.getHeight() / 2 - size.height / 2, size.width, size.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getProgressIcon().getPreferredSize();
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon() {
            return this.getProgressIcon(this.mySmall);
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon(boolean small) {
            if (small) {
                if (this.mySmallProgressIcon == null) {
                    this.mySmallProgressIcon = new AsyncProcessIcon("Android layout rendering");
                    Disposer.register((Disposable)DesignSurface.this, (Disposable)this.mySmallProgressIcon);
                }
                return this.mySmallProgressIcon;
            }
            if (this.myLargeProgressIcon == null) {
                this.myLargeProgressIcon = new AsyncProcessIcon.Big("Android layout rendering");
                Disposer.register((Disposable)DesignSurface.this, (Disposable)this.myLargeProgressIcon);
            }
            return this.myLargeProgressIcon;
        }
    }

    private static class GlassPane
    extends JComponent {
        private static final long EVENT_FLAGS = 56L;

        public GlassPane() {
            this.enableEvents(56L);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.enableEvents(56L);
            } else {
                this.disableEvents(56L);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent event) {
            if (!event.isConsumed()) {
                super.processKeyEvent(event);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent event) {
            if (event.getID() == 501) {
                this.requestFocusInWindow();
            }
            super.processMouseEvent(event);
        }
    }

    private class MyLayeredPane
    extends JLayeredPane
    implements Magnificator,
    DataProvider {
        public MyLayeredPane() {
            this.setOpaque(true);
            this.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, this);
        }

        public Point magnify(double scale, Point at) {
            DesignSurface.this.setScale(scale * DesignSurface.this.myScale);
            DesignSurface.this.repaint();
            return new Point((int)((double)at.x * scale), (int)((double)at.y * scale));
        }

        @Override
        protected void paintComponent(@NotNull Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g2d = (Graphics2D)graphics;
            int tlx = DesignSurface.this.myScrollPane.getHorizontalScrollBar().getValue();
            int tly = DesignSurface.this.myScrollPane.getVerticalScrollBar().getValue();
            this.paintBackground(g2d, tlx, tly);
            if (DesignSurface.this.getCurrentSceneView() == null) {
                return;
            }
            for (Layer layer : DesignSurface.this.myLayers) {
                if (layer.isHidden()) continue;
                layer.paint(g2d);
            }
            if (!DesignSurface.this.getLayoutType().isSupportedByDesigner()) {
                return;
            }
            List<Layer> layers = DesignSurface.this.myInteractionManager.getLayers();
            if (layers != null) {
                for (Layer layer : layers) {
                    if (layer.isHidden()) continue;
                    layer.paint(g2d);
                }
            }
        }

        private void paintBackground(@NotNull Graphics2D graphics, int lx, int ly) {
            int width = DesignSurface.this.myScrollPane.getWidth();
            int height = DesignSurface.this.myScrollPane.getHeight();
            graphics.setColor((Color)DesignSurface.this.getBackgroundColor());
            graphics.fillRect(lx, ly, width, height);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            SelectionModel selectionModel;
            NlComponent primary;
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && DesignSurface.this.getCurrentSceneView() != null && (primary = (selectionModel = DesignSurface.this.getCurrentSceneView().getSelectionModel()).getPrimary()) != null) {
                return primary.getTag();
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) && DesignSurface.this.getCurrentSceneView() != null) {
                selectionModel = DesignSurface.this.getCurrentSceneView().getSelectionModel();
                ImmutableList<NlComponent> selection = selectionModel.getSelection();
                ArrayList list = Lists.newArrayListWithCapacity((int)selection.size());
                for (NlComponent component2 : selection) {
                    list.add(component2.getTag());
                }
                return list.toArray(XmlTag.EMPTY);
            }
            return null;
        }
    }

    private static class MyScrollBar
    extends JBScrollBar
    implements IdeGlassPane.TopComponent {
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
            super(orientation);
            this.setOpaque(false);
        }

        public boolean canBePreprocessed(MouseEvent e) {
            return JBScrollPane.canBePreprocessed((MouseEvent)e, (JScrollBar)((Object)this));
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
            this.setOpaque(false);
        }

        public int getUnitIncrement(int direction) {
            return 5;
        }

        public int getBlockIncrement(int direction) {
            return 1;
        }
    }

    private static class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setOpaque(true);
            this.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.setupCorners();
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            return new MyScrollBar(1);
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            return new MyScrollBar(0);
        }
    }
}

