/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignSurfaceActionHandler
implements DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    private final DesignSurface mySurface;

    public DesignSurfaceActionHandler(@NotNull DesignSurface surface) {
        this.mySurface = surface;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        NlModel model = this.mySurface.getModel();
        if (model == null) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)CopyCutTransferable.createCopyTransferable(model.getSelectionAsTransferable()));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return this.hasNonEmptySelection();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (SystemInfo.isMac) {
            this.performCopy(dataContext);
            this.deleteElement(dataContext);
            return;
        }
        NlModel model = this.mySurface.getModel();
        if (model == null) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)CopyCutTransferable.createCutTransferable(model.getSelectionAsTransferable()));
        this.deleteElement(dataContext);
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        return this.hasNonEmptySelection();
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        SceneView sceneView = this.mySurface.getCurrentSceneView();
        if (sceneView == null) {
            return;
        }
        SelectionModel selectionModel = sceneView.getSelectionModel();
        NlModel model = sceneView.getModel();
        model.delete((Collection<NlComponent>)selectionModel.getSelection());
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        return this.hasNonEmptySelection();
    }

    public void performPaste(@NotNull DataContext dataContext) {
        this.pasteOperation(false);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        return this.pasteOperation(true);
    }

    private boolean hasNonEmptySelection() {
        SceneView sceneView = this.mySurface.getCurrentSceneView();
        return sceneView != null && !sceneView.getSelectionModel().isEmpty();
    }

    private boolean pasteOperation(boolean checkOnly) {
        DragType dragType;
        DnDTransferItem dndTransferItem;
        NlComponent before;
        ImmutableList<NlComponent> components;
        NlComponent receiver;
        SceneView sceneView = this.mySurface.getCurrentSceneView();
        if (sceneView == null) {
            return false;
        }
        ImmutableList<NlComponent> selection = sceneView.getSelectionModel().getSelection();
        NlComponent nlComponent = receiver = !selection.isEmpty() ? (NlComponent)selection.get(0) : null;
        if (receiver == null && (components = sceneView.getModel().getComponents()).size() == 1) {
            receiver = (NlComponent)components.get(0);
        }
        if (receiver == null) {
            return false;
        }
        NlModel model = sceneView.getModel();
        ViewHandlerManager handlerManager = ViewHandlerManager.get(model.getProject());
        ViewHandler handler = handlerManager.getHandler(receiver);
        if (handler instanceof ViewGroupHandler) {
            before = receiver.getChild(0);
        } else {
            before = receiver.getNextSibling();
            if ((receiver = receiver.getParent()) == null) {
                return false;
            }
        }
        if (!SystemInfo.isMac) {
            CopyCutTransferable item = DesignSurfaceActionHandler.getClipboardData(checkOnly);
            DnDTransferItem dnDTransferItem = dndTransferItem = item != null ? item.getDndTransferItem() : null;
            if (dndTransferItem == null) {
                return false;
            }
            dragType = item.isCut() ? DragType.MOVE : DragType.PASTE;
        } else {
            dragType = DragType.PASTE;
            dndTransferItem = DesignSurfaceActionHandler.getMacClipboardData();
            if (dndTransferItem == null) {
                return false;
            }
        }
        InsertType insertType = model.determineInsertType(dragType, dndTransferItem, checkOnly);
        List<NlComponent> pasted = NlModelHelperKt.createComponents(model, sceneView, dndTransferItem, insertType);
        if (!model.canAddComponents(pasted, receiver, before)) {
            return false;
        }
        if (checkOnly) {
            return true;
        }
        model.addComponents(pasted, receiver, before, insertType);
        return true;
    }

    @Nullable
    private static CopyCutTransferable getClipboardData(boolean checkOnly) {
        CopyPasteManager instance = CopyPasteManager.getInstance();
        Transferable contents = instance.getContents();
        if (contents == null || !(contents instanceof CopyCutTransferable)) {
            return null;
        }
        CopyCutTransferable transferItem = (CopyCutTransferable)contents;
        if (!checkOnly && transferItem.isCut()) {
            transferItem.consumeCut();
            return new CopyCutTransferable(transferItem.myTransferable, true);
        }
        return transferItem;
    }

    @Nullable
    private static DnDTransferItem getMacClipboardData() {
        try {
            Object data = CopyPasteManager.getInstance().getContents(ItemTransferable.DESIGNER_FLAVOR);
            if (!(data instanceof DnDTransferItem)) {
                return null;
            }
            return (DnDTransferItem)data;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class CopyCutTransferable
    implements Transferable {
        private final Transferable myTransferable;
        private boolean myCut;

        private CopyCutTransferable(@NotNull Transferable transferable, boolean isCut) {
            this.myTransferable = transferable;
            this.myCut = isCut;
        }

        @NotNull
        private static CopyCutTransferable createCutTransferable(@NotNull Transferable transferable) {
            return new CopyCutTransferable(transferable, true);
        }

        @NotNull
        private static CopyCutTransferable createCopyTransferable(@NotNull Transferable transferable) {
            return new CopyCutTransferable(transferable, false);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.myTransferable.getTransferDataFlavors();
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            return this.myTransferable.isDataFlavorSupported(flavor);
        }

        @Override
        public Object getTransferData(@NotNull DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.myTransferable.getTransferData(dataFlavor);
        }

        public boolean isCut() {
            return this.myCut;
        }

        private void consumeCut() {
            this.myCut = false;
        }

        @Nullable
        private DnDTransferItem getDndTransferItem() {
            try {
                Object data = this.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                return data instanceof DnDTransferItem ? (DnDTransferItem)data : null;
            }
            catch (UnsupportedFlavorException | IOException e) {
                return null;
            }
        }
    }
}

