/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.ScreenRound;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneView {
    protected final DesignSurface mySurface;
    protected final NlModel myModel;
    private int x;
    private int y;

    public SceneView(@NotNull DesignSurface surface, @NotNull NlModel model) {
        this.mySurface = surface;
        this.myModel = model;
    }

    @NotNull
    public Scene getScene() {
        return this.mySurface.getScene();
    }

    @NotNull
    public Dimension getSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        Dimension preferred = this.getPreferredSize(dimension);
        double scale = this.mySurface.getScale();
        dimension.setSize((int)(scale * (double)preferred.width), (int)(scale * (double)preferred.height));
        return dimension;
    }

    @NotNull
    public Dimension getPreferredSize() {
        return this.getPreferredSize(null);
    }

    @NotNull
    public Dimension getSize() {
        return this.getSize(null);
    }

    @NotNull
    public abstract Dimension getPreferredSize(@Nullable Dimension var1);

    public void switchDevice() {
        List<Device> devices = ConfigurationManager.getOrCreateInstance(this.myModel.getFacet()).getDevices();
        ArrayList applicable = Lists.newArrayList();
        for (Device device : devices) {
            if (!HardwareConfigHelper.isNexus((Device)device)) continue;
            applicable.add(device);
        }
        Configuration configuration = this.getConfiguration();
        Device currentDevice = configuration.getDevice();
        int n = applicable.size();
        for (int i = 0; i < n; ++i) {
            if (applicable.get(i) != currentDevice) continue;
            Device newDevice = (Device)applicable.get((i + 1) % applicable.size());
            configuration.setDevice(newDevice, true);
            break;
        }
    }

    public void toggleOrientation() {
        Configuration configuration = this.getConfiguration();
        configuration.getDeviceState();
        State current = configuration.getDeviceState();
        State flip = configuration.getNextDeviceState(current);
        if (flip != null) {
            configuration.setDeviceState(flip);
        }
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.myModel.getConfiguration();
    }

    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.myModel.getSelectionModel();
    }

    @Nullable
    public Shape getScreenShape() {
        Device device = this.getConfiguration().getDevice();
        if (device == null) {
            return null;
        }
        Screen screen = device.getDefaultHardware().getScreen();
        if (screen.getScreenRound() != ScreenRound.ROUND) {
            return null;
        }
        Dimension size = this.getSize();
        int chin = screen.getChin();
        int originX = this.getX();
        int originY = this.getY();
        if (chin == 0) {
            return new Ellipse2D.Double(originX, originY, size.width, size.height);
        }
        int height = size.height * chin / screen.getYDimension();
        Area a1 = new Area(new Ellipse2D.Double(originX, originY, size.width, size.height + height));
        Area a2 = new Area(new Rectangle2D.Double(originX, originY + 2 * (size.height + height) - height, size.width, height));
        a1.subtract(a2);
        return a1;
    }

    @NotNull
    public DesignSurface getSurface() {
        return this.mySurface;
    }

    public double getScale() {
        return this.mySurface.getScale();
    }

    public void setLocation(int screenX, int screenY) {
        this.x = screenX;
        this.y = screenY;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getContentTranslationX() {
        return 0;
    }

    public int getContentTranslationY() {
        return 0;
    }

    public void updateCursor(int x, int y) {
        SceneContext.get(this).setMouseLocation(x, y);
        this.getScene().mouseHover(SceneContext.get(this), Coordinates.getAndroidXDip(this, x), Coordinates.getAndroidYDip(this, y));
        this.mySurface.setCursor(this.getScene().getMouseCursor());
    }

    public SceneManager getSceneManager() {
        return this.mySurface.getSceneManager();
    }

    public void setToolTip(String toolTip) {
        this.mySurface.setDesignToolTip(toolTip);
    }

    @NotNull
    public abstract Color getBgColor();
}

