/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.util;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.base.MoreObjects;
import com.intellij.psi.xml.XmlTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTreeDumper {
    private final Map<NlComponent, Integer> myComponentIds = new HashMap<NlComponent, Integer>();
    private final boolean myIncludeIdentity;

    public NlTreeDumper() {
        this(true);
    }

    private NlTreeDumper(boolean includeIdentity) {
        this.myIncludeIdentity = includeIdentity;
    }

    @NotNull
    public static String dumpTree(@NotNull List<NlComponent> roots) {
        return new NlTreeDumper(false).toTree(roots);
    }

    @NotNull
    public String toTree(@NotNull List<NlComponent> roots) {
        StringBuilder sb = new StringBuilder(200);
        for (NlComponent root : roots) {
            this.describe(sb, root, 0);
        }
        return sb.toString().trim();
    }

    private void describe(@NotNull StringBuilder sb, @NotNull NlComponent component2, int depth) {
        for (int i = 0; i < depth; ++i) {
            sb.append("    ");
        }
        sb.append(this.describe(component2));
        sb.append('\n');
        for (NlComponent child : component2.getChildren()) {
            this.describe(sb, child, depth + 1);
        }
    }

    @NotNull
    private String describe(@NotNull NlComponent root) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)root).omitNullValues().add("tag", (Object)NlTreeDumper.describe(root.getTag()));
        if (NlComponentHelperKt.getHasNlComponentInfo(root)) {
            helper.add("bounds", (Object)("[" + NlComponentHelperKt.getX(root) + "," + NlComponentHelperKt.getY(root) + ":" + NlComponentHelperKt.getW(root) + "x" + NlComponentHelperKt.getH(root)));
        }
        if (this.myIncludeIdentity) {
            helper.add("instance", this.getInstanceId(root));
        }
        return helper.toString();
    }

    @NotNull
    private static String describe(@Nullable XmlTag tag) {
        if (tag == null) {
            return "";
        }
        return '<' + tag.getName() + '>';
    }

    private int getInstanceId(@NotNull NlComponent root) {
        Integer id = this.myComponentIds.get(root);
        if (id == null) {
            id = this.myComponentIds.size();
            this.myComponentIds.put(root, id);
        }
        return id;
    }
}

