/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.Locale;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="config")
public class ConfigurationProjectState {
    @Nullable
    private String myLocale;
    @Nullable
    private String myTarget;
    private boolean myPickTarget = true;
    @NotNull
    private List<String> myDeviceIds = new ArrayList<String>();

    @Property(surroundWithTag=false)
    @Tag(value="devices")
    @AbstractCollection(surroundWithTag=false, elementTag="device", elementValueAttribute="id")
    @NotNull
    public List<String> getDeviceIds() {
        return this.myDeviceIds;
    }

    public void setDeviceIds(@NotNull List<String> deviceIds) {
        this.myDeviceIds = deviceIds;
    }

    @Tag(value="locale")
    @Nullable
    public String getLocale() {
        return this.myLocale;
    }

    public void setLocale(@Nullable String locale) {
        this.myLocale = locale;
    }

    @Tag(value="target")
    @Nullable
    public String getTarget() {
        return this.myTarget;
    }

    public void setTarget(@Nullable String target) {
        this.myTarget = target;
    }

    @Tag(value="pickBest")
    public boolean isPickTarget() {
        return this.myPickTarget;
    }

    public void setPickTarget(boolean pickTarget) {
        this.myPickTarget = pickTarget;
    }

    @Nullable
    static IAndroidTarget fromTargetString(@NotNull ConfigurationManager manager, @Nullable String targetString) {
        if (targetString != null) {
            for (IAndroidTarget target : manager.getTargets()) {
                if (!targetString.equals(target.hashString()) || !ConfigurationManager.isLayoutLibTarget(target)) continue;
                return target;
            }
        }
        return null;
    }

    @NotNull
    static Locale fromLocaleString(@Nullable String locale) {
        if (locale == null) {
            return Locale.ANY;
        }
        return Locale.create(locale);
    }

    @Nullable
    static String toLocaleString(@Nullable Locale locale) {
        if (locale == null || locale == Locale.ANY) {
            return null;
        }
        return locale.qualifier.getFolderSegment();
    }

    @Nullable
    static String toTargetString(@Nullable IAndroidTarget target) {
        return target != null ? target.hashString() : null;
    }
}

