/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.resources.NightMode;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrientationMenuAction
extends DropDownAction {
    private final ConfigurationHolder myRenderContext;
    private final EditorDesignSurface mySurface;

    public OrientationMenuAction(@NotNull ConfigurationHolder renderContext, @Nullable EditorDesignSurface surface) {
        super("", "Orientation in Editor", StudioIcons.LayoutEditor.Toolbar.ROTATE_BUTTON);
        this.myRenderContext = renderContext;
        this.mySurface = surface;
    }

    @NotNull
    private static String getPresentationDescription(@NotNull State state) {
        return String.format("Switch to %1$s", state.getName());
    }

    protected boolean updateActions() {
        this.removeAll();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            Device device = configuration.getDevice();
            if (device != null) {
                List states = device.getAllStates();
                State current = configuration.getDeviceState();
                if (states.size() > 1 && current != null) {
                    State flip = configuration.getNextDeviceState(current);
                    State nextSate = flip == null ? current : flip;
                    String title = OrientationMenuAction.getPresentationDescription(nextSate);
                    this.add(new SetDeviceStateAction(this.myRenderContext, title, nextSate, true));
                    this.addSeparator();
                }
                for (State config : states) {
                    String stateName;
                    String title = stateName = config.getName();
                    VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, stateName, null, null);
                    if (better != null) {
                        title = ConfigurationAction.getBetterMatchLabel(stateName, better, configuration.getFile());
                    }
                    this.add(new SetDeviceStateAction(this.myRenderContext, title, config, false));
                }
                this.addSeparator();
            }
            this.addSeparator();
            DefaultActionGroup uiModeGroup = new DefaultActionGroup("_UI Mode", true);
            UiMode currentUiMode = configuration.getUiMode();
            for (State uiMode : UiMode.values()) {
                String title = uiMode.getShortDisplayValue();
                boolean checked = uiMode == currentUiMode;
                uiModeGroup.add((AnAction)new SetUiModeAction(this.myRenderContext, title, (UiMode)uiMode, checked));
            }
            this.add((AnAction)uiModeGroup);
            this.addSeparator();
            DefaultActionGroup nightModeGroup = new DefaultActionGroup("_Night Mode", true);
            NightMode currentNightMode = configuration.getNightMode();
            for (NightMode nightMode : NightMode.values()) {
                String title = nightMode.getShortDisplayValue();
                boolean checked = nightMode == currentNightMode;
                nightModeGroup.add((AnAction)new SetNightModeAction(this.myRenderContext, title, nightMode, checked));
            }
            this.add((AnAction)nightModeGroup);
            if (this.mySurface != null) {
                this.addSeparator();
                this.createVariationsActions(configuration, this.mySurface);
            }
        }
        return true;
    }

    private void createVariationsActions(@NotNull Configuration configuration, @NotNull EditorDesignSurface surface) {
        VirtualFile virtualFile = configuration.getFile();
        if (virtualFile != null) {
            ResourceFolderType folderType;
            Module module = configuration.getModule();
            if (module == null) {
                return;
            }
            Project project = module.getProject();
            List<VirtualFile> variations = ResourceHelper.getResourceVariations(virtualFile, true);
            if (variations.size() > 1) {
                for (VirtualFile file : variations) {
                    String title = String.format("Switch to %1$s", file.getParent().getName());
                    this.add(new SwitchToVariationAction(title, project, file, virtualFile.equals(file)));
                }
                this.addSeparator();
            }
            if ((folderType = ResourceHelper.getFolderType(configuration.getFile())) == ResourceFolderType.LAYOUT) {
                boolean haveLandscape = false;
                boolean haveLarge = false;
                for (VirtualFile file : variations) {
                    ScreenSizeQualifier size;
                    FolderConfiguration config;
                    String name = file.getParent().getName();
                    if (!name.startsWith("layout") || (config = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
                    ScreenOrientationQualifier orientation = config.getScreenOrientationQualifier();
                    if (orientation != null && orientation.getValue() == ScreenOrientation.LANDSCAPE) {
                        haveLandscape = true;
                        if (haveLarge) break;
                    }
                    if ((size = config.getScreenSizeQualifier()) == null || size.getValue() != ScreenSize.XLARGE) continue;
                    haveLarge = true;
                    if (!haveLandscape) continue;
                    break;
                }
                if (!haveLandscape) {
                    this.add(new CreateVariationAction(surface, "Create Landscape Variation", "layout-land"));
                }
                if (!haveLarge) {
                    this.add(new CreateVariationAction(surface, "Create layout-xlarge Variation", "layout-xlarge"));
                }
                this.add(new CreateVariationAction(surface, "Create Other...", null));
            } else {
                this.add(new CreateVariationAction(surface, "Create Alternative...", null));
            }
        }
    }

    @NotNull
    public static Icon getOrientationIcon(@NotNull ScreenOrientation orientation, boolean flip) {
        switch (orientation) {
            case LANDSCAPE: {
                return flip ? AndroidIcons.FlipLandscape : AndroidIcons.Landscape;
            }
            case SQUARE: {
                return AndroidIcons.Square;
            }
        }
        return flip ? AndroidIcons.FlipPortrait : AndroidIcons.Portrait;
    }

    @NotNull
    public static ScreenOrientation getOrientation(@NotNull State state) {
        FolderConfiguration config = DeviceConfigHelper.getFolderConfig((State)state);
        ScreenOrientation orientation = null;
        if (config != null && config.getScreenOrientationQualifier() != null) {
            orientation = config.getScreenOrientationQualifier().getValue();
        }
        if (orientation == null) {
            orientation = ScreenOrientation.PORTRAIT;
        }
        return orientation;
    }

    private static class CreateVariationAction
    extends AnAction {
        @NotNull
        private EditorDesignSurface mySurface;
        @Nullable
        private String myNewFolder;

        public CreateVariationAction(@NotNull EditorDesignSurface surface, @NotNull String title, @Nullable String newFolder) {
            super(title, null, null);
            this.mySurface = surface;
            this.myNewFolder = newFolder;
        }

        public void actionPerformed(AnActionEvent e) {
            OverrideResourceAction.forkResourceFile(this.mySurface, this.myNewFolder, true);
        }
    }

    private static class SwitchToVariationAction
    extends AnAction {
        private final Project myProject;
        private final VirtualFile myFile;

        public SwitchToVariationAction(@NotNull String title, @NotNull Project project, @NotNull VirtualFile file, boolean select) {
            super(title, null, null);
            this.myFile = file;
            this.myProject = project;
            if (select) {
                Presentation templatePresentation = this.getTemplatePresentation();
                templatePresentation.setIcon(AllIcons.Actions.Checked);
                templatePresentation.setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, this.myFile, -1);
            FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
        }
    }

    private static class SetNightModeAction
    extends ConfigurationAction {
        @NotNull
        private final NightMode myNightMode;

        private SetNightModeAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull NightMode nightMode, boolean checked) {
            super(renderContext, title);
            this.myNightMode = nightMode;
            if (checked) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setNightMode(this.myNightMode);
        }
    }

    private static class SetUiModeAction
    extends ConfigurationAction {
        @NotNull
        private final UiMode myUiMode;

        private SetUiModeAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull UiMode uiMode, boolean checked) {
            super(renderContext, title);
            this.myUiMode = uiMode;
            if (checked) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setUiMode(this.myUiMode);
        }
    }

    private static class SetDeviceStateAction
    extends ConfigurationAction {
        @NotNull
        private final State myState;

        private SetDeviceStateAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull State state, boolean flip) {
            super(renderContext, title);
            this.myState = state;
            ScreenOrientation orientation = OrientationMenuAction.getOrientation(state);
            this.getTemplatePresentation().setIcon(OrientationMenuAction.getOrientationIcon(orientation, flip));
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setDeviceState(this.myState);
        }
    }
}

