/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeMenuAction
extends AnAction {
    private final ConfigurationHolder myRenderContext;

    public ThemeMenuAction(@NotNull ConfigurationHolder renderContext) {
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Theme in Editor");
        presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.THEME_BUTTON);
        this.updatePresentation(presentation);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            String brief = ThemeMenuAction.getThemeLabel(configuration.getTheme(), true);
            this.getTemplatePresentation().setText(brief, false);
            presentation.setText(brief, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    @NotNull
    public static String getThemeLabel(@Nullable String theme, boolean brief) {
        int index;
        if (theme == null) {
            return "";
        }
        theme = ResourceHelper.styleToTheme(theme);
        if (brief && (index = theme.lastIndexOf(46)) < theme.length() - 1) {
            return theme.substring(index + 1);
        }
        return theme;
    }

    public void actionPerformed(AnActionEvent e) {
        String theme;
        ThemeSelectionDialog dialog;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (dialog = new ThemeSelectionDialog(configuration)).showAndGet() && (theme = dialog.getTheme()) != null) {
            configuration.setTheme(theme);
        }
    }
}

