/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.utils.HtmlBuilder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.concurrent.Executor;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RestartAdbActionStateManager
extends AssistActionStateManager
implements AndroidDebugBridge.IDebugBridgeChangeListener {
    @Nullable
    private Project myProject;
    @Nullable
    private ListenableFuture<AndroidDebugBridge> myAdbFuture;
    private boolean myLoading;

    @NotNull
    private static String generateMessage(@NotNull IDevice[] devices) {
        if (devices.length == 0) {
            return AndroidBundle.message("connection.assistant.adb.no_devices", new Object[0]);
        }
        HtmlBuilder builder = new HtmlBuilder().openHtmlBody();
        builder.add(AndroidBundle.message("connection.assistant.adb.devices", new Object[0])).newline();
        for (IDevice device : devices) {
            builder.addHtml("<h2>" + device.getName() + "</h2>").newline().add(device.getVersion().toString()).newlineIfNecessary();
        }
        return builder.closeHtmlBody().getHtml();
    }

    @Override
    @NotNull
    public String getId() {
        return "connection.restart.adb";
    }

    @Override
    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        this.myProject = project;
        this.initDebugBridge(this.myProject);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    @Override
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        if (this.myLoading) {
            return DefaultActionState.IN_PROGRESS;
        }
        if (this.myAdbFuture == null) {
            return DefaultActionState.INCOMPLETE;
        }
        if (!this.myAdbFuture.isDone()) {
            return DefaultActionState.IN_PROGRESS;
        }
        AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
        if (adb == null || adb.getDevices().length == 0) {
            return DefaultActionState.ERROR_RETRY;
        }
        return DefaultActionState.PARTIALLY_COMPLETE;
    }

    @Override
    @NotNull
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message) {
        AssistActionState state = this.getState(project, actionData);
        if (message == null) {
            message = "";
        }
        if (state == DefaultActionState.IN_PROGRESS) {
            message = AndroidBundle.message("connection.assistant.adb.loading", new Object[0]);
        } else if (state == DefaultActionState.PARTIALLY_COMPLETE || state == DefaultActionState.ERROR_RETRY) {
            AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
            message = adb != null ? RestartAdbActionStateManager.generateMessage(adb.getDevices()) : AndroidBundle.message("connection.assistant.adb.failure", new Object[0]);
        }
        return new StatefulButtonMessage(message, state);
    }

    private void setLoading(boolean loading) {
        this.myLoading = loading;
        if (this.myProject != null) {
            this.refreshDependencyState(this.myProject);
        }
    }

    private void initDebugBridge(final @NotNull Project project) {
        File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            return;
        }
        this.myAdbFuture = AdbService.getInstance().getDebugBridge(adb);
        if (this.myAdbFuture == null) {
            return;
        }
        Futures.addCallback(this.myAdbFuture, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                RestartAdbActionStateManager.this.refreshDependencyState(project);
            }

            public void onFailure(@Nullable Throwable t) {
                RestartAdbActionStateManager.this.refreshDependencyState(project);
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
    }

    public void restartInitiated() {
        this.setLoading(true);
    }

    public void restartCompleted(boolean isSuccessful) {
        this.setLoading(false);
    }
}

