/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.LightBrClass;
import com.android.tools.idea.databinding.ModuleDataBinding;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrClassFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;
    private CachedValue<Map<String, PsiClass>> myClassByPackageCache;

    public BrClassFinder(DataBindingProjectComponent component2) {
        this.myComponent = component2;
        this.myClassByPackageCache = CachedValuesManager.getManager((Project)component2.getProject()).createCachedValue(() -> {
            HashMap<String, LightBrClass> classes = new HashMap<String, LightBrClass>();
            for (AndroidFacet facet : this.myComponent.getDataBindingEnabledFacets()) {
                if (!ModuleDataBinding.isEnabled(facet)) continue;
                classes.put(DataBindingUtil.getBrQualifiedName(facet), DataBindingUtil.getOrCreateBrClassFor(facet));
            }
            return CachedValueProvider.Result.create(classes, (Object[])new Object[]{this.myComponent});
        }, false);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (!this.isEnabled() || !qualifiedName.endsWith("BR")) {
            return null;
        }
        PsiClass psiClass = (PsiClass)((Map)this.myClassByPackageCache.getValue()).get(qualifiedName);
        if (psiClass == null) {
            return null;
        }
        PsiFile containingFile = psiClass.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!scope.accept(virtualFile)) {
            return null;
        }
        return psiClass;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (!this.isEnabled()) {
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass aClass = this.findClass(qualifiedName, scope);
        if (aClass == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        return new PsiClass[]{aClass};
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        return null;
    }

    private boolean isEnabled() {
        return DataBindingUtil.inMemoryClassGenerationIsEnabled() && this.myComponent.hasAnyDataBindingEnabledFacet();
    }
}

