/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingClassFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;

    public DataBindingClassFinder(DataBindingProjectComponent component2) {
        this.myComponent = component2;
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (!this.isEnabled()) {
            return null;
        }
        for (AndroidFacet facet : this.myComponent.getDataBindingEnabledFacets()) {
            VirtualFile file;
            DataBindingInfo dataBindingInfo;
            LocalResourceRepository moduleResources = ModuleResourceRepository.getOrCreateInstance(facet);
            Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
            if (dataBindingResourceFiles == null || (dataBindingInfo = dataBindingResourceFiles.get(qualifiedName)) == null || (file = dataBindingInfo.getPsiFile().getVirtualFile()) == null || !scope.accept(file)) continue;
            return DataBindingUtil.getOrCreatePsiClass(dataBindingInfo);
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (!this.isEnabled()) {
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass aClass = this.findClass(qualifiedName, scope);
        if (aClass == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        return new PsiClass[]{aClass};
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        return null;
    }

    private boolean isEnabled() {
        return DataBindingUtil.inMemoryClassGenerationIsEnabled() && this.myComponent.hasAnyDataBindingEnabledFacet();
    }
}

