/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ModuleDataBinding;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class DataBindingProjectComponent
implements ProjectComponent,
ModificationTracker {
    final CachedValue<AndroidFacet[]> myDataBindingEnabledModules;
    final ParameterizedCachedValue<Collection<? extends PsiModifierListOwner>, Module> myBindingAdapterAnnotations;
    final Project myProject;
    private AtomicLong myModificationCount = new AtomicLong(0L);
    private Map<String, PsiPackage> myDataBindingPsiPackages = Maps.newConcurrentMap();

    public DataBindingProjectComponent(Project project) {
        this.myProject = project;
        this.myDataBindingEnabledModules = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
            ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
            for (Module module : modules) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null || !ModuleDataBinding.isEnabled(facet)) continue;
                facets.add(facet);
            }
            this.myModificationCount.incrementAndGet();
            return CachedValueProvider.Result.create((Object)facets.toArray(new AndroidFacet[facets.size()]), (Object[])new Object[]{DataBindingUtil.DATA_BINDING_ENABLED_TRACKER, ModuleManager.getInstance((Project)project)});
        }, false);
        this.myBindingAdapterAnnotations = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue(module -> {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
            PsiClass aClass = facade.findClass("android.databinding.BindingAdapter", module.getModuleWithDependenciesAndLibrariesScope(false));
            Collection<Object> psiElements = null;
            psiElements = aClass == null ? Collections.emptyList() : AnnotatedElementsSearch.searchElements((PsiClass)aClass, (SearchScope)ProjectScope.getAllScope((Project)this.myProject), (Class[])new Class[]{PsiMethod.class}).findAll();
            return CachedValueProvider.Result.create(psiElements, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, ModuleManager.getInstance((Project)project)});
        }, false);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public boolean hasAnyDataBindingEnabledFacet() {
        return this.getDataBindingEnabledFacets().length > 0;
    }

    public AndroidFacet[] getDataBindingEnabledFacets() {
        return (AndroidFacet[])this.myDataBindingEnabledModules.getValue();
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        return "data binding project component";
    }

    public long getModificationCount() {
        return this.myModificationCount.longValue();
    }

    public synchronized PsiPackage getOrCreateDataBindingPsiPackage(String packageName) {
        Object pkg = this.myDataBindingPsiPackages.get(packageName);
        if (pkg == null) {
            pkg = new PsiPackageImpl(PsiManager.getInstance((Project)this.myProject), packageName){

                public boolean isValid() {
                    return true;
                }
            };
            this.myDataBindingPsiPackages.put(packageName, (PsiPackage)pkg);
        }
        return pkg;
    }

    @NotNull
    private static Stream<PsiLiteral> getPsiLiterals(@NotNull PsiAnnotationMemberValue annotationMemberValue) {
        if (annotationMemberValue instanceof PsiArrayInitializerMemberValue) {
            return Arrays.stream(((PsiArrayInitializerMemberValue)annotationMemberValue).getInitializers()).filter(PsiLiteral.class::isInstance).map(PsiLiteral.class::cast);
        }
        if (annotationMemberValue instanceof PsiLiteral) {
            return Stream.of((PsiLiteral)annotationMemberValue);
        }
        return Stream.empty();
    }

    @NotNull
    public Stream<String> getBindingAdapterAttributes(@NotNull Module module) {
        return ((Collection)this.myBindingAdapterAnnotations.getValue((Object)module)).stream().map(PsiModifierListOwner::getModifierList).filter(Objects::nonNull).flatMap(modifierList -> Stream.of(modifierList.getAnnotations())).map(annotation -> annotation.findAttributeValue("value")).filter(Objects::nonNull).flatMap(DataBindingProjectComponent::getPsiLiterals).map(PsiLiteral::getValue).filter(Objects::nonNull).map(Object::toString);
    }
}

