/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.ResourceCacheValueProvider;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectResourceCachedValueProvider<T, V>
implements CachedValueProvider<T>,
ModificationTracker {
    private Map<AndroidFacet, CachedValue<V>> myCachedValues = Maps.newHashMap();
    private final ModificationTracker[] myAdditionalTrackers;
    private List<ModificationTracker> myDependencies = Lists.newArrayList();
    private DataBindingProjectComponent myComponent;
    private long myDependencyModificationCountOnCompute;
    private long myModificationCount = 0L;

    public long getModificationCount() {
        long newCount = ProjectResourceCachedValueProvider.calculateModificationCountFrom(this.myDependencies);
        if (newCount != this.myDependencyModificationCountOnCompute) {
            ++this.myModificationCount;
        }
        return this.myModificationCount;
    }

    public ProjectResourceCachedValueProvider(DataBindingProjectComponent component2, ModificationTracker ... additionalTrackers) {
        this.myComponent = component2;
        this.myAdditionalTrackers = additionalTrackers;
    }

    @Nullable
    public final CachedValueProvider.Result<T> compute() {
        AndroidFacet[] facets = this.myComponent.getDataBindingEnabledFacets();
        ArrayList values = Lists.newArrayList();
        ArrayList newDependencies = Lists.newArrayList();
        newDependencies.add(this.myComponent);
        Collections.addAll(newDependencies, this.myAdditionalTrackers);
        for (AndroidFacet facet : facets) {
            Object result;
            CachedValue<V> cachedValue = this.getCachedValue(facet);
            if (cachedValue.getValueProvider() instanceof ModificationTracker) {
                newDependencies.add((ModificationTracker)cachedValue.getValueProvider());
            }
            if ((result = cachedValue.getValue()) == null) continue;
            values.add(result);
        }
        this.myDependencies = Collections.unmodifiableList(newDependencies);
        this.myDependencyModificationCountOnCompute = ProjectResourceCachedValueProvider.calculateModificationCountFrom(this.myDependencies);
        return CachedValueProvider.Result.create(this.merge(values), (Object[])new Object[]{this});
    }

    private static long calculateModificationCountFrom(List<ModificationTracker> dependencies2) {
        long total = 0L;
        for (ModificationTracker tracker : dependencies2) {
            total += tracker.getModificationCount();
        }
        return total;
    }

    @NotNull
    protected abstract T merge(List<V> var1);

    private CachedValue<V> getCachedValue(AndroidFacet facet) {
        CachedValue cachedValue = this.myCachedValues.get((Object)facet);
        if (cachedValue == null) {
            ResourceCacheValueProvider<V> cacheProvider = this.createCacheProvider(facet);
            cachedValue = CachedValuesManager.getManager((Project)facet.getModule().getProject()).createCachedValue(cacheProvider, false);
            this.myCachedValues.put(facet, cachedValue);
        }
        return cachedValue;
    }

    abstract ResourceCacheValueProvider<V> createCacheProvider(AndroidFacet var1);

    public static abstract class MergedMapValueProvider<A, B>
    extends ProjectResourceCachedValueProvider<Map<A, List<B>>, Map<A, List<B>>> {
        public MergedMapValueProvider(DataBindingProjectComponent component2, ModificationTracker ... additionalTrackers) {
            super(component2, additionalTrackers);
        }

        @Override
        @NotNull
        protected Map<A, List<B>> merge(List<Map<A, List<B>>> results) {
            HashMap merged = Maps.newHashMap();
            for (Map<A, List<B>> result : results) {
                for (Map.Entry<A, List<B>> entry : result.entrySet()) {
                    List bList = (List)merged.get(entry.getKey());
                    if (bList == null) {
                        bList = Lists.newArrayList();
                        merged.put(entry.getKey(), bList);
                    }
                    bList.addAll((Collection)entry.getValue());
                }
            }
            return merged;
        }
    }
}

