/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DevicePropertyUtil {
    private static final Set<String> ourManufacturerNameIsAcronym = ImmutableSet.of((Object)"ASUS", (Object)"HTC", (Object)"LG", (Object)"LGE", (Object)"ZTE");

    static String fixManufacturerName(@NotNull String manufacturer) {
        String allCaps = manufacturer.toUpperCase(Locale.US);
        return ourManufacturerNameIsAcronym.contains(allCaps) ? allCaps : StringUtil.capitalizeWords((String)manufacturer, (boolean)true);
    }

    @NotNull
    public static String getManufacturer(@NotNull IDevice d, @NotNull String unknown) {
        String m = d.getProperty("ro.product.manufacturer");
        if (d.isEmulator() && "unknown".equals(m)) {
            m = unknown;
        }
        return m != null ? DevicePropertyUtil.fixManufacturerName(m) : unknown;
    }

    @NotNull
    public static String getModel(@NotNull IDevice d, @NotNull String unknown) {
        String m = d.getProperty("ro.product.model");
        return m != null ? StringUtil.capitalizeWords((String)m, (boolean)true) : unknown;
    }

    @NotNull
    public static String getBuild(@NotNull IDevice d) {
        StringBuilder sb = new StringBuilder(20);
        String v = d.getProperty("ro.build.version.release");
        if (v != null) {
            sb.append("Android ");
            sb.append(v);
        }
        if ((v = d.getProperty("ro.build.version.sdk")) != null) {
            sb.append(String.format(", API %1$s", v));
        }
        return sb.toString();
    }
}

