/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import java.util.HashSet;
import java.util.List;
import javax.swing.JList;
import javax.swing.JTable;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceRenderer {
    private DeviceRenderer() {
    }

    public static void renderDeviceName(@NotNull IDevice d, @NotNull ColoredTextContainer component2, boolean showSerialNumber) {
        DeviceRenderer.renderDeviceName(d, component2, showSerialNumber, null);
    }

    public static void renderDeviceName(@NotNull IDevice d, @NotNull ColoredTextContainer component2, boolean showSerialNumber, @Nullable AvdManager avdManager) {
        component2.setIcon(d.isEmulator() ? AndroidIcons.Ddms.Emulator2 : AndroidIcons.Ddms.RealDevice);
        String name = d.isEmulator() ? DeviceRenderer.getEmulatorDeviceName(d, avdManager) : DeviceRenderer.getDeviceName(d);
        component2.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        IDevice.DeviceState deviceState = d.getState();
        if (deviceState != IDevice.DeviceState.ONLINE) {
            String state = String.format("%1$s [%2$s] ", d.getSerialNumber(), d.getState());
            component2.append(state, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        } else if (showSerialNumber) {
            String state = String.format("%1$s ", d.getSerialNumber());
            component2.append(state, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
        if (deviceState != IDevice.DeviceState.DISCONNECTED && deviceState != IDevice.DeviceState.OFFLINE) {
            component2.append(DevicePropertyUtil.getBuild(d), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getEmulatorDeviceName(@NotNull IDevice d, @Nullable AvdManager avdManager) {
        AvdInfo info;
        String avdName = d.getAvdName();
        if (avdManager != null && (info = avdManager.getAvd(avdName, true)) != null) {
            avdName = (String)info.getProperties().get("avd.ini.displayname");
        }
        if (avdName == null) {
            avdName = "unknown";
        }
        return String.format("%1$s %2$s ", AndroidBundle.message("android.emulator", new Object[0]), avdName);
    }

    @NotNull
    private static String getDeviceName(@NotNull IDevice d) {
        return String.format("%1$s %2$s ", DevicePropertyUtil.getManufacturer(d, ""), DevicePropertyUtil.getModel(d, ""));
    }

    public static boolean shouldShowSerialNumbers(@NotNull List<IDevice> devices) {
        HashSet myNames = Sets.newHashSet();
        for (IDevice currentDevice : devices) {
            if (currentDevice.isEmulator()) continue;
            String currentName = DeviceRenderer.getDeviceName(currentDevice);
            if (myNames.contains(currentName)) {
                return true;
            }
            myNames.add(currentName);
        }
        return false;
    }

    public static class DeviceNameRenderer
    extends ColoredTableCellRenderer {
        private static final ExtensionPointName<DeviceNameRendererEx> EP_NAME = ExtensionPointName.create((String)"com.android.run.deviceNameRenderer");
        private final DeviceNameRendererEx[] myRenderers = (DeviceNameRendererEx[])EP_NAME.getExtensions();
        private final AvdManager myAvdManager;

        public DeviceNameRenderer(@Nullable AvdManager avdManager) {
            this.myAvdManager = avdManager;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (!(value instanceof IDevice)) {
                return;
            }
            IDevice device = (IDevice)value;
            for (DeviceNameRendererEx renderer : this.myRenderers) {
                if (!renderer.isApplicable(device)) continue;
                renderer.render(device, (ColoredTextContainer)this);
                return;
            }
            DeviceRenderer.renderDeviceName(device, (ColoredTextContainer)this, false, this.myAvdManager);
        }
    }

    public static class DeviceComboBoxRenderer
    extends ColoredListCellRenderer {
        @NotNull
        private String myEmptyText;
        private boolean myShowSerial;

        public DeviceComboBoxRenderer(@NotNull String emptyText, boolean showSerial) {
            this.myEmptyText = emptyText;
            this.myShowSerial = showSerial;
        }

        public void setShowSerial(boolean showSerial) {
            this.myShowSerial = showSerial;
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof String) {
                this.append((String)value, SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (value instanceof IDevice) {
                DeviceRenderer.renderDeviceName((IDevice)value, (ColoredTextContainer)this, this.myShowSerial);
            } else if (value == null) {
                this.append(this.myEmptyText, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }
    }
}

