/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.Client;
import com.android.layoutinspector.model.ClientWindow;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractClientAction;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorCaptureTask;
import com.android.tools.idea.editors.layoutInspector.WindowPickerDialog;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.AndroidIcons;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutInspectorAction
extends AbstractClientAction {
    private final Project myProject;

    public LayoutInspectorAction(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        super(deviceContext, AndroidBundle.message("android.ddms.actions.layoutinspector.title", new Object[0]), AndroidBundle.message("android.ddms.actions.layoutinspector.description", new Object[0]), AndroidIcons.Ddms.LayoutInspector);
        this.myProject = project;
    }

    @Override
    protected void performAction(@NotNull Client client) {
        new GetClientWindowsTask(this.myProject, client).queue();
    }

    public static final class GetClientWindowsTask
    extends Task.Backgroundable {
        private final Client myClient;
        private List<ClientWindow> myWindows;
        private String myError;

        public GetClientWindowsTask(@Nullable Project project, @NotNull Client client) {
            super(project, "Obtaining Windows");
            this.myClient = client;
            this.myError = null;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            indicator.setIndeterminate(true);
            try {
                this.myWindows = ClientWindow.getAll((Client)this.myClient, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                if (this.myWindows == null) {
                    this.myError = "Unable to obtain list of windows used by " + this.myClient.getClientData().getPackageName() + "\nLayout Inspector requires device API version to be 18 or greater.";
                } else if (this.myWindows.isEmpty()) {
                    this.myError = "No active windows displayed by " + this.myClient.getClientData().getPackageName();
                }
            }
            catch (IOException e) {
                this.myError = "Unable to obtain list of windows used by " + this.myClient.getClientData().getPackageName() + "\nError: " + e.getMessage();
            }
        }

        public void onSuccess() {
            ClientWindow window;
            if (this.myError != null) {
                Messages.showErrorDialog((String)this.myError, (String)"Capture View Hierarchy");
                return;
            }
            if (this.myWindows.size() == 1) {
                window = this.myWindows.get(0);
            } else {
                WindowPickerDialog pickerDialog = new WindowPickerDialog(this.myProject, this.myClient, this.myWindows);
                if (!pickerDialog.showAndGet()) {
                    return;
                }
                window = pickerDialog.getSelectedWindow();
                if (window == null) {
                    return;
                }
            }
            LayoutInspectorCaptureTask captureTask = new LayoutInspectorCaptureTask(this.myProject, this.myClient, window);
            captureTask.queue();
        }
    }
}

