/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.run.DeviceStateCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ScreenRecorderAction
extends AbstractDeviceAction {
    private static final String PKG_NAME = "";
    private final Project myProject;
    private final DeviceStateCache<CompletableFuture> myCache;

    public ScreenRecorderAction(@NotNull Project project, @NotNull DeviceContext context) {
        super(context, AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]), AndroidBundle.message("android.ddms.actions.screenrecord.description", new Object[0]), AndroidIcons.Ddms.ScreenRecorder);
        this.myProject = project;
        this.myCache = new DeviceStateCache((Disposable)project);
    }

    @Override
    protected boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        IDevice device = this.myDeviceContext.getSelectedDevice();
        CompletableFuture<Boolean> cf = this.myCache.get(device, PKG_NAME);
        if (cf == null) {
            cf = CompletableFuture.supplyAsync(() -> device.supportsFeature(IDevice.Feature.SCREEN_RECORD));
            this.myCache.put(device, PKG_NAME, cf);
        }
        return cf.getNow(false);
    }

    @Override
    protected void performAction(@NotNull IDevice device) {
        new com.android.tools.idea.ddms.screenrecord.ScreenRecorderAction(this.myProject, device).performAction();
    }
}

