/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.hprof;

import com.android.SdkConstants;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.ddms.hprof.ConvertHprofDialog;
import com.android.tools.idea.editors.hprof.HprofCaptureType;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureTypeService;
import com.android.tools.idea.profiling.view.CapturesToolWindow;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunHprofConvAndSaveAsAction
extends DumbAwareAction {
    public RunHprofConvAndSaveAsAction() {
        this.getTemplatePresentation().setText(RunHprofConvAndSaveAsAction.getActionName());
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setText(RunHprofConvAndSaveAsAction.getActionName());
        presentation.setVisible(RunHprofConvAndSaveAsAction.isValidCaptureSelection((Capture[])CapturesToolWindow.CAPTURE_ARRAY.getData(e.getDataContext())));
    }

    @NotNull
    public static String getActionName() {
        return AndroidBundle.message("android.profiler.hprof.actions.conv.contextmenu", new Object[0]);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (e.getProject() == null) {
                return;
            }
            ConvertHprofDialog dialog = new ConvertHprofDialog(e.getProject());
            if (!dialog.showAndGet()) {
                return;
            }
            Capture[] captures = (Capture[])CapturesToolWindow.CAPTURE_ARRAY.getData(e.getDataContext());
            if (RunHprofConvAndSaveAsAction.isValidCaptureSelection(captures)) {
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROFILING).setKind(AndroidStudioEvent.EventKind.PROFILING_CONVERT_HPROF));
                new RunHprofConvAndSaveTask(e.getProject(), captures[0].getFile(), dialog.getHprofFile()).queue();
            }
        });
    }

    private static boolean isValidCaptureSelection(@Nullable Capture[] captures) {
        return captures != null && captures.length == 1 && captures[0].getType() == CaptureTypeService.getInstance().getType(HprofCaptureType.class);
    }

    private static class RunHprofConvAndSaveTask
    extends Task.Backgroundable {
        private final VirtualFile mySource;
        private final File myDestination;
        private Exception myException;

        public RunHprofConvAndSaveTask(@Nullable Project project, @NotNull VirtualFile source, @NotNull File destination) {
            super(project, AndroidBundle.message("android.profiler.hprof.actions.conv", new Object[0]), false);
            this.mySource = source;
            this.myDestination = destination;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            try {
                this.convertAndSave();
            }
            catch (Exception e) {
                this.myException = e;
            }
        }

        private void convertAndSave() throws IOException, ExecutionException {
            AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
            if (sdkData == null) {
                throw new ExecutionException("Unable to find path to SDK.");
            }
            String hprofConvPath = new File(sdkData.getLocation(), AndroidCommonUtils.platformToolPath((String)SdkConstants.FN_HPROF_CONV)).getPath();
            List<String> commandLine = Arrays.asList(hprofConvPath, VfsUtilCore.virtualToIoFile((VirtualFile)this.mySource).getAbsolutePath(), this.myDestination.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(commandLine);
            BaseOSProcessHandler handler = new BaseOSProcessHandler(pb.start(), StringUtil.join(commandLine, (String)" "), null);
            final StringBuilder builder = new StringBuilder();
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    builder.append(event.getText());
                }
            });
            handler.startNotify();
            handler.waitFor();
            int exitCode = handler.getProcess().exitValue();
            if (exitCode != 0) {
                throw new ExecutionException(builder.toString().trim());
            }
        }

        public void onSuccess() {
            if (this.myException != null) {
                Messages.showErrorDialog((String)("Unexpected error while converting heap dump: " + this.myException.getMessage()), (String)AndroidBundle.message("android.profiler.hprof.actions.conv", new Object[0]));
            } else {
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myDestination);
                Notifications.Bus.notify((Notification)new Notification("Android", AndroidBundle.message("android.profiler.hprof.actions.conv", new Object[0]), AndroidBundle.message("android.profiler.hprof.actions.conv.saved", this.myDestination.getAbsolutePath()), NotificationType.INFORMATION));
            }
        }
    }
}

