/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.HashMap;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CrashReport {
    public static final String PRODUCT_ANDROID_STUDIO = "AndroidStudio";
    private static final ImmutableSet<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableSet.of(ArrayIndexOutOfBoundsException.class, ClassCastException.class, ClassNotFoundException.class, IndexOutOfBoundsException.class);
    @NotNull
    public final String productId;
    @Nullable
    public final String version;
    @Nullable
    public final Map<String, String> productData;
    @NotNull
    private final Type myType;

    private CrashReport(@NotNull String productId, @Nullable String version, @Nullable Map<String, String> productData, @NotNull Type type) {
        this.productId = productId;
        this.version = version;
        this.productData = productData;
        this.myType = type;
    }

    public void serialize(@NotNull MultipartEntityBuilder builder) {
        builder.addTextBody("type", this.myType.toString());
        if (this.productData != null) {
            this.productData.forEach((arg_0, arg_1) -> ((MultipartEntityBuilder)builder).addTextBody(arg_0, arg_1));
        }
        this.serializeTo(builder);
    }

    protected abstract void serializeTo(@NotNull MultipartEntityBuilder var1);

    @NotNull
    public static Throwable getRootCause(@NotNull Throwable t) {
        int depth = 0;
        while (depth++ < 20) {
            if (t.getCause() == null) {
                return t;
            }
            t = t.getCause();
        }
        return t;
    }

    @NotNull
    public static String getDescription(@NotNull Throwable t) {
        if (THROWABLE_CLASSES_TO_TRACK_MESSAGES.contains(t.getClass())) {
            return ExceptionUtil.getThrowableText((Throwable)t);
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(t.getClass().getName());
        sb.append(": <elided>\n");
        for (StackTraceElement el : t.getStackTrace()) {
            sb.append("\tat ");
            sb.append(el);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static class Builder {
        private String myProductId = "AndroidStudio";
        private String myVersion;
        private Type myType = Type.Exception;
        private String myExceptionInfo = "<unknown>";
        private List<String> myCrashDescriptions;
        private String myThreadDump;
        private String myFileName;
        private Map<String, String> myProductData;

        private Builder() {
        }

        @NotNull
        public Builder setProduct(@NotNull String productId) {
            this.myProductId = productId;
            return this;
        }

        @NotNull
        public Builder setVersion(@NotNull String version) {
            this.myVersion = version;
            return this;
        }

        @NotNull
        public Builder addProductData(@NotNull Map<String, String> kv) {
            if (this.myProductData == null) {
                this.myProductData = new HashMap();
            }
            this.myProductData.putAll(kv);
            return this;
        }

        @NotNull
        private Builder setType(@NotNull Type type) {
            this.myType = type;
            return this;
        }

        @NotNull
        private Builder setThrowable(@NotNull Throwable t) {
            this.myExceptionInfo = CrashReport.getDescription(CrashReport.getRootCause(t));
            return this;
        }

        @NotNull
        private Builder setDescriptions(@NotNull List<String> descriptions) {
            this.myCrashDescriptions = descriptions;
            return this;
        }

        @NotNull
        private Builder setThreadDump(@NotNull String fileName, @NotNull String threadDump) {
            this.myFileName = fileName;
            this.myThreadDump = threadDump;
            return this;
        }

        @NotNull
        public CrashReport build() {
            switch (this.myType) {
                case Crash: {
                    return new StudioCrashReport(this.myProductId, this.myVersion, this.myCrashDescriptions, this.myProductData);
                }
                case Performance: {
                    return new StudioPerformanceWatcherReport(this.myProductId, this.myVersion, this.myFileName, this.myThreadDump, this.myProductData);
                }
            }
            return new ExceptionReport(this.myProductId, this.myVersion, this.myExceptionInfo, this.myProductData);
        }

        @NotNull
        public static Builder createForException(@NotNull Throwable t) {
            return new Builder().setType(Type.Exception).setThrowable(t);
        }

        @NotNull
        public static Builder createForCrashes(@NotNull List<String> descriptions) {
            return new Builder().setType(Type.Crash).setDescriptions(descriptions);
        }

        @NotNull
        public static Builder createForPerfReport(@NotNull String fileName, @NotNull String threadDump) {
            return new Builder().setType(Type.Performance).setThreadDump(fileName, threadDump);
        }
    }

    private static class StudioPerformanceWatcherReport
    extends CrashReport {
        private final String myFileName;
        private final String myThreadDump;

        private StudioPerformanceWatcherReport(@NotNull String productId, @Nullable String version, @NotNull String fileName, @NotNull String threadDump, @Nullable Map<String, String> productData) {
            super(productId, version, productData, Type.Performance);
            this.myFileName = fileName;
            this.myThreadDump = threadDump;
        }

        @Override
        protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
            String edtStack = ThreadDumper.getEdtStackForCrash((String)this.myThreadDump);
            if (edtStack != null) {
                builder.addTextBody("exception_info", edtStack);
            }
            builder.addTextBody(this.myFileName, this.myThreadDump, ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8));
        }
    }

    private static class StudioCrashReport
    extends CrashReport {
        private final List<String> myDescriptions;

        private StudioCrashReport(@NotNull String productId, @Nullable String version, @NotNull List<String> descriptions, @Nullable Map<String, String> productData) {
            super(productId, version, productData, Type.Crash);
            this.myDescriptions = descriptions;
        }

        @Override
        protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
            builder.addTextBody("numCrashes", Integer.toString(this.myDescriptions.size()));
            builder.addTextBody("crashDesc", Joiner.on((String)"\n\n").join(this.myDescriptions));
        }
    }

    private static class ExceptionReport
    extends CrashReport {
        @NotNull
        private final String myExceptionInfo;

        private ExceptionReport(@NotNull String productId, @Nullable String version, @NotNull String exceptionInfo, @Nullable Map<String, String> productData) {
            super(productId, version, productData, Type.Exception);
            this.myExceptionInfo = exceptionInfo;
        }

        @Override
        protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
            builder.addTextBody("exception_info", this.myExceptionInfo);
        }
    }

    public static enum Type {
        Crash,
        Exception,
        Performance;

    }
}

