/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.Anonymizer;
import com.android.tools.idea.diagnostics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.android.tools.idea.diagnostics.crash.UploadRateLimiter;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCrash
implements CrashReporter {
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication() == null;
    private static final boolean DEBUG_BUILD = !UNIT_TEST_MODE && ApplicationManager.getApplication().isInternal();
    private static final String CRASH_URL = UNIT_TEST_MODE || DEBUG_BUILD ? "https://clients2.google.com/cr/staging_report" : "https://clients2.google.com/cr/report";
    @Nullable
    private static final String ANONYMIZED_UID = GoogleCrash.getAnonymizedUid();
    private static final String LOCALE = Locale.getDefault() == null ? "unknown" : Locale.getDefault().toString();
    private static final int REJECTED_UPLOAD_TRIGGER_COUNT = 20;
    private static AtomicInteger ourRejectedExecutionCount = new AtomicInteger();
    private static final ExecutorService ourExecutor = new ThreadPoolExecutor(1, 5, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(5), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("google-crash-pool-%d").build(), (r, executor) -> {
        ourRejectedExecutionCount.incrementAndGet();
        if (ourRejectedExecutionCount.compareAndSet(20, 0)) {
            Logger.getInstance(GoogleCrash.class).info("Lost 20 crash events due to full queue.");
        }
    });
    static final String KEY_PRODUCT_ID = "productId";
    static final String KEY_VERSION = "version";
    static final String KEY_EXCEPTION_INFO = "exception_info";
    private static final double MAX_CRASHES_PER_SEC = 0.016666666666666666;
    private final String myCrashUrl;
    private final UploadRateLimiter myRateLimiter;

    @Nullable
    private static String getAnonymizedUid() {
        if (UNIT_TEST_MODE) {
            return "UnitTest";
        }
        try {
            return Anonymizer.anonymizeUtf8((ILogger)new NullLogger(), (String)UpdateChecker.getInstallationUID((PropertiesComponent)PropertiesComponent.getInstance()));
        }
        catch (IOException e) {
            return null;
        }
    }

    GoogleCrash() {
        this(CRASH_URL, UploadRateLimiter.create(0.016666666666666666));
    }

    @VisibleForTesting
    GoogleCrash(@NotNull String crashUrl, @NotNull UploadRateLimiter rateLimiter) {
        this.myCrashUrl = crashUrl;
        this.myRateLimiter = rateLimiter;
    }

    @Override
    @NotNull
    public CompletableFuture<String> submit(@NotNull CrashReport report) {
        return this.submit(report, false);
    }

    @Override
    @NotNull
    public CompletableFuture<String> submit(@NotNull CrashReport report, boolean userReported) {
        if (!userReported && !this.myRateLimiter.tryAcquire()) {
            CompletableFuture<String> f = new CompletableFuture<String>();
            f.completeExceptionally(new RuntimeException("Exceeded Quota of crashes that can be reported"));
            return f;
        }
        Map<String, String> parameters = GoogleCrash.getDefaultParameters();
        if (report.version != null) {
            parameters.put(KEY_VERSION, report.version);
        }
        parameters.put(KEY_PRODUCT_ID, report.productId);
        MultipartEntityBuilder builder = GoogleCrash.newMultipartEntityBuilderWithKv(parameters);
        report.serialize(builder);
        return this.submit(builder.build());
    }

    @Override
    @NotNull
    public CompletableFuture<String> submit(@NotNull Map<String, String> kv) {
        Map<String, String> parameters = GoogleCrash.getDefaultParameters();
        kv.forEach(parameters::put);
        return this.submit(GoogleCrash.newMultipartEntityBuilderWithKv(parameters).build());
    }

    @Override
    @NotNull
    public CompletableFuture<String> submit(@NotNull HttpEntity requestEntity) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            ourExecutor.submit(() -> {
                try {
                    CloseableHttpClient client = HttpClients.createDefault();
                    HttpEntity entity = requestEntity;
                    if (!UNIT_TEST_MODE) {
                        entity = new GzipCompressingEntity(requestEntity);
                    }
                    HttpPost post = new HttpPost(this.myCrashUrl);
                    post.setEntity(entity);
                    HttpResponse response = client.execute((HttpUriRequest)post);
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() >= 300) {
                        future.completeExceptionally((Throwable)new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                        return;
                    }
                    entity = response.getEntity();
                    if (entity == null) {
                        future.completeExceptionally(new NullPointerException("Empty response entity"));
                        return;
                    }
                    String reportId = EntityUtils.toString((HttpEntity)entity);
                    if (DEBUG_BUILD) {
                        System.out.println("Report submitted: http://go/crash-staging/" + reportId);
                    }
                    future.complete(reportId);
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return future;
    }

    @NotNull
    private static MultipartEntityBuilder newMultipartEntityBuilderWithKv(@NotNull Map<String, String> kv) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        kv.forEach((arg_0, arg_1) -> ((MultipartEntityBuilder)builder).addTextBody(arg_0, arg_1));
        return builder;
    }

    @NotNull
    private static Map<String, String> getDefaultParameters() {
        HashMap map = new HashMap();
        ApplicationInfo applicationInfo = GoogleCrash.getApplicationInfo();
        if (ANONYMIZED_UID != null) {
            map.put("guid", ANONYMIZED_UID);
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        map.put("ptime", Long.toString(runtimeMXBean.getUptime()));
        map.put(KEY_VERSION, applicationInfo == null ? "0.0.0.0" : applicationInfo.getStrictVersion());
        map.put(KEY_PRODUCT_ID, "AndroidStudio");
        map.put("fullVersion", applicationInfo == null ? "0.0.0.0" : applicationInfo.getFullVersion());
        map.put("osName", StringUtil.notNullize((String)SystemInfo.OS_NAME));
        map.put("osVersion", StringUtil.notNullize((String)SystemInfo.OS_VERSION));
        map.put("osArch", StringUtil.notNullize((String)SystemInfo.OS_ARCH));
        map.put("locale", StringUtil.notNullize((String)LOCALE));
        map.put("vmName", StringUtil.notNullize((String)runtimeMXBean.getVmName()));
        map.put("vmVendor", StringUtil.notNullize((String)runtimeMXBean.getVmVendor()));
        map.put("vmVersion", StringUtil.notNullize((String)runtimeMXBean.getVmVersion()));
        MemoryUsage usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        map.put("heapUsed", Long.toString(usage.getUsed()));
        map.put("heapCommitted", Long.toString(usage.getCommitted()));
        map.put("heapMax", Long.toString(usage.getMax()));
        return map;
    }

    @Nullable
    private static ApplicationInfo getApplicationInfo() {
        return ApplicationManager.getApplication() == null ? null : ApplicationInfo.getInstance();
    }
}

