/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations.nodes;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.idea.editors.allocations.nodes.AbstractTreeNode;
import com.android.tools.idea.editors.allocations.nodes.AllocNode;
import com.android.tools.idea.editors.allocations.nodes.PackageNode;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ClassNode
extends PackageNode {
    @NotNull
    private Map<String, AllocNode> mySimilarObjectsMap = new HashMap<String, AllocNode>();

    public ClassNode(@NotNull String name) {
        super(name);
    }

    @Override
    protected void addChild(@NotNull AbstractTreeNode node) {
        assert (node instanceof AllocNode);
        AllocationInfo allocInfo = ((AllocNode)node).getAllocation();
        String key = String.format("%s,%s", allocInfo.getAllocatedClass(), allocInfo.getSize());
        if (this.mySimilarObjectsMap.containsKey(key)) {
            this.mySimilarObjectsMap.get(key).incrementCount();
        } else {
            super.addChild(node);
            this.mySimilarObjectsMap.put(key, (AllocNode)node);
        }
    }
}

