/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations.nodes;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.idea.editors.allocations.nodes.MainTreeNode;
import com.android.tools.idea.editors.allocations.nodes.PackageNode;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PackageRootNode
extends PackageNode
implements MainTreeNode {
    @NotNull
    private final Pattern myFilter;

    public PackageRootNode(@NotNull String name, @NotNull Pattern filter) {
        super(name);
        this.myFilter = filter;
    }

    public PackageRootNode(@NotNull String name, @NotNull String filter) {
        this(name, PackageRootNode.globToRegex(filter));
    }

    @Override
    public void insert(@NotNull AllocationInfo alloc) {
        String[] packages;
        StackTraceElement[] trace = alloc.getStackTrace();
        if (trace.length > 0) {
            String name;
            int ix;
            int match = 0;
            for (int i = 0; i < trace.length; ++i) {
                if (!this.myFilter.matcher(trace[i].getClassName()).matches()) continue;
                match = i;
                break;
            }
            name = (ix = (name = trace[match].getClassName()).indexOf(36)) >= 0 ? name.substring(0, ix) : name;
            packages = name.split("\\.");
        } else {
            packages = new String[]{"< Unknown >"};
        }
        this.insert(packages, alloc, 0);
    }

    static Pattern globToRegex(@NotNull String glob) {
        String regex = "";
        int ix = glob.indexOf(42);
        while (ix != -1) {
            regex = regex + Pattern.quote(glob.substring(0, ix));
            regex = regex + ".*";
            glob = glob.substring(ix + 1);
            ix = glob.indexOf(42);
        }
        regex = regex + Pattern.quote(glob);
        return Pattern.compile(".*" + regex + ".*");
    }
}

