/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.fonts;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.template.emmet.generators.LoremGenerator;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.FontFormatException;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FontEditor
implements FileEditor {
    private static final Logger LOG = Logger.getInstance(FontEditor.class);
    private static final String NAME = "Font";
    private static final float MAX_FONT_SIZE = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL) + JBUI.scale((float)30.0f);
    private static final float MIN_FONT_SIZE = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI);
    private static final Border BORDER = JBUI.Borders.empty((int)50);
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private final JTextArea myTextArea;
    private final VirtualFile myFile;
    private final JPanel myRootPanel;
    private float myCurrentFontSize;

    public FontEditor(@NotNull VirtualFile file) {
        this.myFile = file;
        this.myRootPanel = new JPanel(new BorderLayout());
        this.myTextArea = new JTextArea("Center");
        this.myTextArea.setLineWrap(true);
        this.myTextArea.setWrapStyleWord(true);
        this.myTextArea.setBorder(BORDER);
        this.myCurrentFontSize = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL) + JBUI.scale((float)15.0f);
        try {
            Font font = Font.createFont(0, file.getInputStream()).deriveFont(this.myCurrentFontSize);
            this.myTextArea.setFont(font);
            this.myTextArea.setText(font.getFontName() + "\n\n" + new LoremGenerator().generate(50, true));
            this.myTextArea.addMouseWheelListener(e -> {
                float increment = e.getWheelRotation() < 0 ? -1.0f : 1.0f;
                float newFontSize = Math.min(Math.max(MIN_FONT_SIZE, this.myCurrentFontSize + increment), MAX_FONT_SIZE);
                if (newFontSize != this.myCurrentFontSize) {
                    this.myCurrentFontSize = newFontSize;
                    Font newFont = this.myTextArea.getFont().deriveFont(this.myCurrentFontSize);
                    this.myTextArea.setFont(newFont);
                }
            });
        }
        catch (FontFormatException | IOException e2) {
            String message = "Unable to open font " + file.getName();
            this.myTextArea.setFont(UIUtil.getLabelFont());
            this.myTextArea.setEditable(false);
            this.myTextArea.setText(message);
            LOG.warn(message, (Throwable)e2);
        }
        this.myRootPanel.add(this.myTextArea);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTextArea;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }
}

