/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.hprof.HprofView;
import com.android.tools.idea.editors.hprof.views.HprofAnalysisContentsDelegate;
import com.android.tools.idea.profiling.view.CaptureEditor;
import com.android.tools.idea.profiling.view.CapturePanel;
import com.android.tools.perflib.analyzer.AnalysisReport;
import com.android.tools.perflib.analyzer.AnalyzerTask;
import com.android.tools.perflib.analyzer.Capture;
import com.android.tools.perflib.analyzer.CaptureGroup;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.captures.MemoryMappedFileBuffer;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.analysis.ComputationProgress;
import com.android.tools.perflib.heap.memoryanalyzer.DuplicatedStringsAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.LeakedActivityAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzer;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.util.ui.UIUtil;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HprofEditor
extends CaptureEditor {
    @NotNull
    private static final Logger LOG = Logger.getInstance(HprofEditor.class);
    @Nullable
    private HprofView myView;
    @Nullable
    private Snapshot mySnapshot;
    private boolean myIsValid = true;

    public HprofEditor(@NotNull Project project, @NotNull VirtualFile file) {
        AnalyzerTask[] tasks = new AnalyzerTask[]{new LeakedActivityAnalyzerTask(), new DuplicatedStringsAnalyzerTask()};
        this.myPanel = new CapturePanel(project, this, tasks, true);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Snapshot snapshot;
            File hprofFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            InlineProgressIndicator indicator = this.myPanel.getProgressIndicator();
            assert (indicator != null);
            try {
                HprofEditor.updateIndicator(indicator, 0.01, "Parsing hprof file...");
                snapshot = Snapshot.createSnapshot((DataBuffer)new MemoryMappedFileBuffer(hprofFile));
            }
            catch (Throwable t) {
                this.showErrorWhileProcessingFile(project, indicator, t);
                return;
            }
            Timer timer = new Timer(33, actionEvent -> {
                Snapshot.DominatorComputationStage stage = snapshot.getDominatorComputationStage();
                ComputationProgress progress = snapshot.getComputationProgress();
                HprofEditor.updateIndicator(indicator, Snapshot.DominatorComputationStage.toAbsoluteProgressPercentage((Snapshot.DominatorComputationStage)stage, (ComputationProgress)progress), progress.getMessage());
            });
            timer.start();
            try {
                snapshot.computeDominators();
            }
            catch (Throwable t) {
                this.showErrorWhileProcessingFile(project, indicator, t);
                return;
            }
            finally {
                timer.stop();
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.isValid()) {
                    snapshot.dispose();
                } else {
                    this.mySnapshot = snapshot;
                    this.myView = new HprofView(project, this, snapshot);
                    HprofAnalysisContentsDelegate delegate = new HprofAnalysisContentsDelegate(this);
                    this.myPanel.setEditorPanel(this.myView.getComponent(), delegate);
                    Disposer.register((Disposable)this, (Disposable)this.myView);
                    Disposer.register((Disposable)this, (Disposable)delegate);
                }
            });
        });
    }

    @Nullable
    public HprofView getView() {
        return this.myView;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return "HprofView";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public void setInvalid() {
        this.myIsValid = false;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        this.myIsValid = false;
        if (this.mySnapshot != null) {
            this.mySnapshot.dispose();
        }
        this.mySnapshot = null;
        this.myPanel = null;
    }

    @Override
    @NotNull
    public DesignerEditorPanelFacade getFacade() {
        return this.myPanel;
    }

    @Override
    @NotNull
    public AnalysisReport performAnalysis(@NotNull Set<? extends AnalyzerTask> tasks, @NotNull Set<AnalysisReport.Listener> listeners) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CaptureGroup captureGroup = new CaptureGroup();
        assert (this.mySnapshot != null);
        captureGroup.addCapture((Capture)this.mySnapshot);
        MemoryAnalyzer memoryAnalyzer = new MemoryAnalyzer();
        assert (memoryAnalyzer.accept(captureGroup));
        return memoryAnalyzer.analyze(captureGroup, listeners, tasks, (Executor)EdtExecutor.INSTANCE, Executors.newSingleThreadExecutor());
    }

    private static void updateIndicator(@NotNull InlineProgressIndicator indicator, double fraction, @NotNull String text) {
        UIUtil.invokeLaterIfNeeded(() -> {
            indicator.setFraction(fraction);
            indicator.setText(text);
        });
    }

    private void showErrorWhileProcessingFile(@NotNull Project project, @NotNull InlineProgressIndicator indicator, @NotNull Throwable t) {
        LOG.info(t);
        String errorMessage = "Unexpected error while processing hprof file: " + Throwables.getRootCause((Throwable)t).getMessage();
        indicator.cancel();
        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)errorMessage, (String)this.getName()));
    }
}

