/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views.nodedata;

import com.android.tools.idea.editors.hprof.views.nodedata.HeapClassObjNode;
import com.android.tools.idea.editors.hprof.views.nodedata.HeapNode;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapPackageNode
implements HeapNode {
    @Nullable
    private HeapNode myParent;
    @NotNull
    private List<HeapNode> myChildren = new ArrayList<HeapNode>();
    @NotNull
    private HashMap<String, HeapPackageNode> mySubPackages = new HashMap();
    @NotNull
    private Set<HeapClassObjNode> myClasses = new HashSet();
    @NotNull
    private String myFullPackageName;
    @NotNull
    private String myPackageName;
    private int myTotalCount;
    private int myHeapInstanceCount;
    private int myShallowSize;
    private long myRetainedSize;

    public HeapPackageNode(@Nullable HeapPackageNode parent, @NotNull String packageName) {
        this.myPackageName = packageName;
        this.setParent(parent);
    }

    public void update(int currentHeapId) {
        this.myRetainedSize = 0L;
        for (HeapPackageNode heapPackageNode : this.mySubPackages.values()) {
            heapPackageNode.update(currentHeapId);
            this.updateCounts(heapPackageNode, currentHeapId);
        }
        for (HeapClassObjNode heapClassObjNode : this.myClasses) {
            this.updateCounts(heapClassObjNode, currentHeapId);
        }
    }

    private void updateCounts(@NotNull HeapNode heapNode, int currentHeapId) {
        this.myTotalCount += heapNode.getTotalCount();
        this.myHeapInstanceCount += heapNode.getHeapInstancesCount(currentHeapId);
        this.myShallowSize += heapNode.getShallowSize(currentHeapId);
        this.myRetainedSize += heapNode.getRetainedSize();
    }

    public void classifyClassObj(@NotNull HeapClassObjNode heapClassObjNode) {
        String className = heapClassObjNode.getClassObj().getClassName();
        assert (className.startsWith(this.myFullPackageName) && className.length() > this.myFullPackageName.length() + 1);
        String remainder = this.myFullPackageName.isEmpty() ? className : className.substring(this.myFullPackageName.length() + 1);
        int dotIndex = remainder.indexOf(46);
        if (dotIndex > 0) {
            assert (!remainder.isEmpty());
            String subPackageName = remainder.substring(0, dotIndex);
            HeapPackageNode heapPackageNode = this.mySubPackages.get(subPackageName);
            if (heapPackageNode == null) {
                heapPackageNode = new HeapPackageNode(this, subPackageName);
                this.mySubPackages.put(subPackageName, heapPackageNode);
            }
            heapPackageNode.classifyClassObj(heapClassObjNode);
        } else {
            this.myClasses.add(heapClassObjNode);
        }
    }

    public void clear() {
        this.removeAllChildren();
        this.mySubPackages.clear();
        this.myClasses.clear();
        this.myTotalCount = 0;
        this.myHeapInstanceCount = 0;
        this.myShallowSize = 0;
        this.myRetainedSize = 0L;
    }

    @Override
    @NotNull
    public String getFullName() {
        return this.myFullPackageName;
    }

    @Override
    @NotNull
    public String getSimpleName() {
        return this.myPackageName;
    }

    @Override
    public int getTotalCount() {
        return this.myTotalCount;
    }

    @Override
    public int getHeapInstancesCount(int heapId) {
        return this.myHeapInstanceCount;
    }

    @Override
    public int getInstanceSize() {
        return -1;
    }

    @Override
    public int getShallowSize(int heapId) {
        return this.myShallowSize;
    }

    @Override
    public long getRetainedSize() {
        return this.myRetainedSize;
    }

    @Override
    public void add(@NotNull HeapNode heapNode) {
        heapNode.removeFromParent();
        heapNode.setParent(this);
        this.myChildren.add(heapNode);
    }

    @Override
    @NotNull
    public List<HeapNode> getChildren() {
        return this.myChildren;
    }

    @Override
    public void removeAllChildren() {
        for (HeapNode child : this.myChildren) {
            child.setParent(null);
        }
        this.myChildren.clear();
    }

    @NotNull
    public HashMap<String, HeapPackageNode> getSubPackages() {
        return this.mySubPackages;
    }

    public void buildTree() {
        for (HeapPackageNode heapPackageNode : this.mySubPackages.values()) {
            this.add(heapPackageNode);
            heapPackageNode.buildTree();
        }
        for (HeapClassObjNode heapClassObjNode : this.myClasses) {
            this.add(heapClassObjNode);
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.myChildren.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode node) {
        assert (node instanceof HeapNode);
        return this.myChildren.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.myChildren);
    }

    public void remove(@NotNull HeapNode node) {
        this.myChildren.remove(node);
    }

    @Override
    public void removeFromParent() {
        if (this.myParent != null) {
            assert (this.myParent instanceof HeapPackageNode);
            ((HeapPackageNode)this.myParent).remove(this);
            this.setParent(null);
        }
    }

    @Override
    public void setParent(@Nullable HeapNode newParent) {
        assert (newParent == null || newParent instanceof HeapPackageNode);
        this.myParent = newParent;
        this.myFullPackageName = this.myParent == null || this.myParent.getFullName().isEmpty() ? this.myPackageName : this.myParent.getFullName() + "." + this.myPackageName;
    }
}

