/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector;

import com.android.ddmlib.Client;
import com.android.layoutinspector.model.ClientWindow;
import com.android.tools.idea.editors.layoutInspector.LayoutFileData;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorContext;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorEditorPanel;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutInspectorEditor
extends UserDataHolderBase
implements FileEditor {
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private LayoutInspectorEditorPanel myPanel;
    private LayoutInspectorContext myContext;

    public LayoutInspectorEditor(@NotNull Project project, @NotNull VirtualFile file) {
        this.myVirtualFile = file;
        this.myProject = project;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myPanel == null) {
            try {
                this.myContext = new LayoutInspectorContext(new LayoutFileData(this.myVirtualFile));
            }
            catch (IOException e) {
                return new JLabel(e.getLocalizedMessage(), 0);
            }
            this.myPanel = new LayoutInspectorEditorPanel(this, this.myProject, this.myContext);
        }
        return this.myPanel;
    }

    public void dispose() {
    }

    @NotNull
    public String getName() {
        return "Layout Inspector";
    }

    public void setState(@NotNull FileEditorState state) {
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    public void deselectNotify() {
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void selectNotify() {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public boolean isModified() {
        return false;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public boolean isValid() {
        return this.myVirtualFile.isValid();
    }

    public void setSources(@Nullable Client client, @Nullable ClientWindow window) {
        this.myContext.setSources(client, window);
    }
}

