/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ptable;

import com.android.tools.adtui.ptable.PNameRenderer;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellRenderer;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.editors.layoutInspector.ui.PropertiesTablePanel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class LITableNameRenderer
implements PNameRenderer {
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final PTableCellRenderer myRenderer = new Renderer();

    public LITableNameRenderer() {
        this.myPanel.add((Component)this.myRenderer, "Center");
    }

    public Component getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        this.myRenderer.clear();
        PTableItem item = (PTableItem)value;
        this.myRenderer.getTableCellRendererComponent(table, value, isSelected, cellHasFocus, row, column);
        this.myRenderer.setBackground(isSelected ? UIUtil.getTableSelectionBackground() : (item.hasChildren() ? PropertiesTablePanel.GROUP_BACKGROUND_COLOR : PropertiesTablePanel.ITEM__BACKGROUND_COLOR));
        this.myPanel.setBackground(isSelected ? UIUtil.getTableSelectionBackground() : (item.hasChildren() ? PropertiesTablePanel.GROUP_BACKGROUND_COLOR : PropertiesTablePanel.ITEM__BACKGROUND_COLOR));
        String label = item.getParent() != null ? item.getParent().getChildLabel(item) : item.getName();
        this.myRenderer.append(label, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myRenderer.setToolTipText(item.getTooltipText());
        this.myRenderer.setBorder((Border)new EmptyBorder(1, 1, 1, 1));
        return this.myPanel;
    }

    public boolean hitTestTreeNodeIcon(@NotNull PTableItem item, int x, int y) {
        Icon icon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)true, (boolean)true);
        int beforeIcon = LITableNameRenderer.getBeforeIconSpacing(LITableNameRenderer.getDepth(item), icon.getIconWidth());
        return x >= beforeIcon && x <= beforeIcon + icon.getIconWidth();
    }

    private static int getBeforeIconSpacing(int depth, int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return nodeIndent * depth + leftIconOffset;
    }

    private static int getAfterIconSpacing(int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return Math.max(0, nodeIndent - leftIconOffset - iconWidth);
    }

    private static int getDepth(@NotNull PTableItem item) {
        int result = 0;
        while (item.getParent() != null) {
            ++result;
            item = item.getParent();
            assert (item != null);
        }
        return result;
    }

    private static class Renderer
    extends PTableCellRenderer {
        private Renderer() {
        }

        protected void customizeCellRenderer(@NotNull PTable table, @NotNull PTableItem value, boolean selected, boolean hasFocus, int row, int column) {
            this.setIcon(value, selected, hasFocus);
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
        }

        private void setIcon(@NotNull PTableItem item, boolean selected, boolean hasFocus) {
            int textGap;
            int indent;
            Icon icon;
            Icon groupIcon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)selected, (boolean)hasFocus);
            if (item.hasChildren()) {
                icon = groupIcon;
                indent = LITableNameRenderer.getBeforeIconSpacing(LITableNameRenderer.getDepth(item), groupIcon.getIconWidth());
                textGap = LITableNameRenderer.getAfterIconSpacing(groupIcon.getIconWidth());
            } else {
                icon = null;
                indent = 2;
                textGap = 0;
            }
            this.setIcon(icon);
            this.setIconTextGap(textGap);
            this.setIpad((Insets)JBUI.insetsLeft((int)indent));
        }
    }
}

